/*----------------------------------------------------------------------------*/
/* Copyright 2014-2023 NXP                                                    */
/*                                                                            */
/* NXP Confidential. This software is owned or controlled by NXP and may only */
/* be used strictly in accordance with the applicable license terms.          */
/* By expressly accepting such terms or by downloading, installing,           */
/* activating and/or otherwise using the software, you are agreeing that you  */
/* have read, and that you agree to comply with and are bound by, such        */
/* license terms. If you do not agree to be bound by the applicable license   */
/* terms, then you may not retain, install, activate or otherwise use the     */
/* software.                                                                  */
/*----------------------------------------------------------------------------*/

/** @file
 *
 * phExSystemServices.h: System services header file.
 *
 * Project:  PN7462AU
 *
 * $Date: $
 * $Author: $
 * $Revision: $ (v07.12.00)
 */

#ifndef PHEXSYSTEMSERVICES_H_
#define PHEXSYSTEMSERVICES_H_

/* Set of user interface commands. */
#define PH_EXSYS_SERV_SECROW_LOCK              1
#define PH_EXSYS_SERV_ENABLE_CWP               2
#define PH_EXSYS_SERV_BLOCK_SWD                3
#define PH_EXSYS_SERV_DIS_PRI_DWNLD            4
#define PH_EXSYS_SERV_UPDATE_PID               5
#define PH_EXSYS_SERV_UPDATE_VID               6
#define PH_EXSYS_SERV_IAP                      7
#define PH_EXSYS_SET_INTERNAL_PVDD             8
#define PH_EXSYS_GET_ROM_VERSION               9

const uint8_t gkcArray[10][50] = {
        "Invalid Command!!!", /* Any way not used. */
        "1: Perform Secrow Lock.\n",
        "2: Enable Code write protection.\n",
        "3: Block SWD debugging.\n",
        "4: Disable primary download.\n",
        "5: Update Product ID.\n",
        "6: Update Vendor ID.\n",
        "7: Perform InApplication Programming.\n",
        "8: Set internal PVDD.\n",
        "9: Get Rom version.\n"
};

/**
 * User configurable values.
 */
uint8_t gkbaFlashPageData[128] = {
        0x54, 0x68, 0x69, 0x73, 0x20, 0x69, 0x73, 0x20, 0x6a, 0x75, 0x73, 0x74, 0x20, 0x70, 0x73, 0x75,
        0x64, 0x6f, 0x20, 0x72, 0x61, 0x6e, 0x64, 0x6f, 0x6d, 0x20, 0x31, 0x32, 0x38, 0x62, 0x79, 0x74,
        0x65, 0x20, 0x6c, 0x6f, 0x6e, 0x67, 0x20, 0x62, 0x79, 0x74, 0x65, 0x20, 0x61, 0x72, 0x72, 0x61,
        0x79, 0x20, 0x74, 0x6f, 0x20, 0x73, 0x68, 0x6f, 0x77, 0x20, 0x68, 0x6f, 0x77, 0x20, 0x74, 0x68,
        0x65, 0x20, 0x49, 0x41, 0x50, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x50, 0x4e, 0x37, 0x34, 0x36, 0x32,
        0x41, 0x55, 0x20, 0x63, 0x61, 0x6e, 0x20, 0x62, 0x65, 0x20, 0x64, 0x6f, 0x6e, 0x65, 0x20, 0x76,
        0x69, 0x61, 0x20, 0x74, 0x68, 0x65, 0x20, 0x67, 0x69, 0x76, 0x65, 0x6e, 0x20, 0x53, 0x79, 0x73,
        0x74, 0x65, 0x6d, 0x20, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x20, 0x41, 0x50, 0x49, 0x00};

#endif /* PHEXSYSTEMSERVICES_H_ */
