/*----------------------------------------------------------------------------*/
/* Copyright 2014-2023 NXP                                                    */
/*                                                                            */
/* NXP Confidential. This software is owned or controlled by NXP and may only */
/* be used strictly in accordance with the applicable license terms.          */
/* By expressly accepting such terms or by downloading, installing,           */
/* activating and/or otherwise using the software, you are agreeing that you  */
/* have read, and that you agree to comply with and are bound by, such        */
/* license terms. If you do not agree to be bound by the applicable license   */
/* terms, then you may not retain, install, activate or otherwise use the     */
/* software.                                                                  */
/*----------------------------------------------------------------------------*/

/** \file
* Configuration file needed for USB ROM stack based applications.
* $Author$
* $Revision$ (v04.18.00)
* $Date$
*
*/

#include "ph_Datatypes.h"
#include "error.h"
#include "mw_usbd.h"

#ifndef _APP_USB_CFG_H_
#define _APP_USB_CFG_H_

#ifdef __cplusplus
extern "C"
{
#endif

/** @ingroup EXAMPLES_USBDLIB_11XX_CDC
 * @{
 */

#define PN7462AU_USB_BASE                      0x40028000UL

/* Manifest constants used by USBD LIB stack. These values SHOULD NOT BE CHANGED
   for advance features which require usage of USB_CORE_CTRL_T structure.
   Since these are the values used for compiling USB stack.
 */

#define USB_APP_IF_NUM           1      /*!< Interface Number used for Application requirement.*/
#define USB_APP_EP_NUM           3      /*!< End Point Number used for Application requirement.*/

#define USB_MAX_IF_NUM           3      /*!< Max interface number used for building USBDL_Lib. DON'T CHANGE. */
#define USB_MAX_EP_NUM           6      /*!< Max number of EP used for building USBD_Lib. DON'T CHANGE. */
#define USB_MAX_PACKET0         64      /*!< Max EP0 packet size used for building USBD_Lib. Please understand the system while setting/changing this parameter. */
#define USB_FS_MAX_BULK_PACKET  64      /*!< MAXP for FS bulk EPs used for building USBD_Lib. Please understand the system while setting/changing this parameter. */
#define USB_HS_MAX_BULK_PACKET  64      /*!< MAXP for HS bulk EPs used for building USBD_Lib. Please understand the system while setting/changing this parameter. */
#define USB_DFU_XFER_SIZE       64      /*!< Max DFU transfer size used for building USBD_Lib. Please understand the system while setting/changing this parameter. */

/* Manifest constants defining interface numbers and endpoints used by a
   particular interface in this application.
 */
#define USB_CDC_CIF_NUM         0
#define USB_CDC_DIF_NUM         1
#define USB_CDC_IN_EP           0x81
#define USB_CDC_OUT_EP          0x01
#define USB_CDC_INT_EP          0x82

/* USB descriptor arrays defined *_desc.c file */
extern const uint8_t USB_DeviceDescriptor[];
extern uint8_t USB_FsConfigDescriptor[];
extern const uint8_t USB_StringDescriptor[];
extern const uint8_t USB_DeviceQualifier[];

/**
 * @brief	Find the address of interface descriptor for given class type.
 * @param	pDesc		: Pointer to configuration descriptor in which the desired class
 *			interface descriptor to be found.
 * @param	intfClass	: Interface class type to be searched.
 * @return	If found returns the address of requested interface else returns NULL.
 */
extern USB_INTERFACE_DESCRIPTOR *find_IntfDesc(const uint8_t *pDesc, uint32_t intfClass);

#define FULL_SPEED_ONLY
/**
 * @}
 */

#ifdef __cplusplus
}
#endif

#endif /* _APP_USB_CFG_H_ */
