/*
 *                    Copyright (c), NXP Semiconductors
 *
 *                       (C) NXP Semiconductors 2014,2015
 *
 *         All rights are reserved. Reproduction in whole or in part is
 *        prohibited without the written consent of the copyright owner.
 *    NXP reserves the right to make changes without notice at any time.
 *   NXP makes no warranty, expressed, implied or statutory, including but
 *   not limited to any implied warranty of merchantability or fitness for any
 *  particular purpose, or that the use will not infringe any third party patent,
 *   copyright or trademark. NXP must not be liable for any loss or damage
 *                            arising from its use.
 */

/** @file
 *
 * Run Time configuration settings extracted from EEPROM/FLASH.
 *
 * Project:  PN7462AU
 *
 * $Date: 2016-07-04 23:48:03 +0530 (Mon, 04 Jul 2016) $
 * $Author: Purnank G (ing05193) $
 * $Revision: 18541 $ (v04.18.00)
 */

/* ****************************************************************************************************************** */
/* Generated by user_ee.py version 2016.06.29_00 on 2019-11-13
 */

#include "ph_Datatypes.h"
#include "ph_NxpBuild.h"
#include "phCfg_EE.h"

#ifdef NXPBUILD__CFG_FROM_PF

/* ****************************************************************************************************************** */
/** \name Page: ErrorMem
 * Error Memory written by ROM in case of error
 */

/** Structure: Err
 * Error information during ROM APIs
 */
static const phCfg_EE_ErrorMem_Err_t gkphCfg_EE_ErrorMem_Err_PF = {
    /**
     * Reserved for MRA2 and MRA3
     */
    .str_name = "IntentionallyEmpty",
    /**
     * Error information from ROM Boot
     */
    .dwCauseCode = 0x00,

};
const phCfg_EE_ErrorMem_Err_t * const gpkphCfg_EE_ErrorMem_Err = &gkphCfg_EE_ErrorMem_Err_PF;

/* ****************************************************************************************************************** */
/** \name Page: Ctrl
 * Master Control Block for EEPROM
 */

/** Structure: VerInfo
 *
 * <pre>
 *     Version Information of the Layout
 * 	Version 28.0.0: artf178091: [CR][FW][TXOCP] Load dependent RX gain control
 * 	Version 27.0.0: artf203315 : The Default TVDD source config to be External. DPC 5V by default.
 * 	Version 27.0.0: Clif EEPROM 1.9.2v Settings.
 * 	Version 26.0.0: artf157683 : Changing the wWaitTime of Tx Ldo Params. [15:14] : Lfo Clock Value and [13:0] : Waiting Time after TxLdo is started.
 * 	Version 25.5.0: artf156243 : Update according to the Analysis Information.
 * 	Version 25.4.0: wWaitTime value for Tx Ldo start ir changed from 250us to 1100us.
 *     Version 25.3.0: dwTidtTimeAdjust field added.
 *     Version 25.2.0: RRDD value changed from 28us to 50us and dwExtRfOnTime values to 302us.
 *     Version 25.1.0: Adding the RRDD and Fdt values for Jewel.
 *     Version 25.0.0: Clif EEPROM 1.9v settings
 *     <hr />
 *     Version 24.0.2: [RC4] CLIF_ANA_NFCLD_REG.CM_RFL_NFC set to 7.  [MRA3] v1.8.3 of EEPROM
 *     Version 24.0.1: Refactored dwFelicaRxRMSigproTime
 *     Version 24.0.0: Removed the Rf On and Off De-bouncing structure.
 *                   : Added Rf Inter-Op timings structure and Rf hal timings
 *                   : for different algos.
 *     Version 23.9.0: CLIF_ANA_NFCLD_REG.CM_RFL_NFC value changed from 7 to 3
 *     Version 23.8.0: [MRA2] v1.8   of EEPROM
 *     Version 23.7.0: [MRA2] v1.7.4 of EEPROM
 *     Version 23.6.0: [MRA2] ClkGenClifClockStart->ClkModeAlmCm set to 0x50
 * </pre>
 *
 */
static const phCfg_EE_Ctrl_VerInfo_t gkphCfg_EE_Ctrl_VerInfo_PF = {
    /**
     * Major Version
     */
    .major = 28,
    /**
     * Minor Version
     */
    .minor = 0,
    /**
     * Development Version
     */
    .development = 0,
    /**
     * Canonical name to identify the EE Layout
     */
    .str_name = "Rf#v1.9",

};
const phCfg_EE_Ctrl_VerInfo_t * const gpkphCfg_EE_Ctrl_VerInfo = &gkphCfg_EE_Ctrl_VerInfo_PF;

/* ****************************************************************************************************************** */
/** \name Page: Boot
 * These values are used during during Boot up and applied to HW IPs
 */

/** Structure: RNG
 * Random Number Generator. \see phhalRng_Init
 */
static const phCfg_EE_Boot_RNG_t gkphCfg_EE_Boot_RNG_PF = {
    /**
     * Programmable wait time to release gated clocks feeding the TRNG
     */
    .bTrngFeedTimeout = 0x26,

};
const phCfg_EE_Boot_RNG_t * const gpkphCfg_EE_Boot_RNG = &gkphCfg_EE_Boot_RNG_PF;

/** Structure: ClkGen
 * Clock Generator.  \ref phhalClkGen_Init
 */
static const phCfg_EE_Boot_ClkGen_t gkphCfg_EE_Boot_ClkGen_PF = {
    /**
     * dwXtalActivationTimeOut Activation time out value
     */
    .wXtalActivationTimeOut = 2000,
    /**
     * eSource Clock source selection, \see phhalClkGen_Source_t
     */
    .eSource = 0x00,
    /**
     * bKickOnError Kick on error.
     */
    .bKickOnError = 0x00,

};
const phCfg_EE_Boot_ClkGen_t * const gpkphCfg_EE_Boot_ClkGen = &gkphCfg_EE_Boot_ClkGen_PF;

/** Structure: PcrPwrTempConfig
 * Power Clock Reset Temperature Configuration related to \see phhalPcr_PwrTempConfig_t
 *
 *                 \warning This structure is tightly linked to \ref phhalPcr_PwrTempConfig_t
 *
 */
static const phCfg_EE_Boot_PcrPwrTempConfig_t gkphCfg_EE_Boot_PcrPwrTempConfig_PF = {
    /**
     * Flag to indicate to use temperature sensor 0 or not
     * - 0 => Disabled
     * - 1 => Enabled
     */
    .bUseTempSensor0 = 0,
    /**
     * Flag to indicate to use temperature sensor 1 or not
     * - 0 => Disabled
     * - 1 => Enabled
     */
    .bUseTempSensor1 = 0,
    /**
     * - 0 => 135
     * - 1 => 130
     * - 2 => 125
     * - 3 => 120
     */
    .bLowTempTarget0 = 3,
    /**
     * - 0 => 135
     * - 1 => 130
     * - 2 => 125
     * - 3 => 120
     */
    .bLowTempTarget1 = 3,
    /**
     * - 0 => 135
     * - 1 => 130
     * - 2 => 125
     * - 3 => 120
     */
    .bHighTempTarget0 = 0,
    /**
     * - 0 => 135
     * - 1 => 130
     * - 2 => 125
     * - 3 => 120
     */
    .bHighTempTarget1 = 0,

};
const phCfg_EE_Boot_PcrPwrTempConfig_t * const gpkphCfg_EE_Boot_PcrPwrTempConfig = &gkphCfg_EE_Boot_PcrPwrTempConfig_PF;

/** Structure: PcrPwrDown
 * See \ref phhalPcr_PwrDown_Setting_t
 *
 * It is a 32 bit value bit-file created by ORing enums of type \ref phhalPcr_PwrDown_Setting_t used to select which settings must be applied to reduce power consumption during Suspend
 */
static const phCfg_EE_Boot_PcrPwrDown_t gkphCfg_EE_Boot_PcrPwrDown_PF = {
    /**
     * 0x7FFFFFFF : E_APPLY_ALL_SETTNGS. i.e.  all power reduction settings will be applied during Suspend
     */
    .dwPwrDownSettings = 0x7FFFFFFF,

};
const phCfg_EE_Boot_PcrPwrDown_t * const gpkphCfg_EE_Boot_PcrPwrDown = &gkphCfg_EE_Boot_PcrPwrDown_PF;

/** Structure: TxAnaStandByConfig
 * TxAna register settings for standby  \see phhalPcr_TxAnaStandByConfig_t
 */
static const phCfg_EE_Boot_TxAnaStandByConfig_t gkphCfg_EE_Boot_TxAnaStandByConfig_PF = {
    /**
     * To hold CLIF standby GSN value selection
     */
    .dwAnaTxStandByValue = 0x0F,
    /**
     * To hold the CLIF configuration related to powerdown
     */
    .dwAnaTxProtStandByValue = 0x03,

};
const phCfg_EE_Boot_TxAnaStandByConfig_t * const gpkphCfg_EE_Boot_TxAnaStandByConfig = &gkphCfg_EE_Boot_TxAnaStandByConfig_PF;

/** Structure: EEPROM
 * EEPROM Access Settings. \see phhalEeprom_Init
 */
static const phCfg_EE_Boot_EEPROM_t gkphCfg_EE_Boot_EEPROM_PF = {
    /**
     * Disable Fast mode for EEPROM access
     * - 0 => Disabled
     * - 1 => Enabled
     */
    .bEnableFastMode = 0,

};
const phCfg_EE_Boot_EEPROM_t * const gpkphCfg_EE_Boot_EEPROM = &gkphCfg_EE_Boot_EEPROM_PF;

/** Structure: FLASH
 * Flash Settings. \see phhalFlash_Init
 */
static const phCfg_EE_Boot_FLASH_t gkphCfg_EE_Boot_FLASH_PF = {
    /**
     * Enable or Disable fast mode for Page Flash access
     * - 0 => Disabled
     * - 1 => Enabled
     */
    .bEnableFastMode = 0,
    /**
     * Setting to decide if program phase will be attempted in the event of an erase phase failure
     * - 0 => Program phase will be attempted even if erase phase failed
     * - 1 => Program phase will be skipped if erase phase failed
     */
    .bEnableSkipProgramOnEraseFail = 1,

};
const phCfg_EE_Boot_FLASH_t * const gpkphCfg_EE_Boot_FLASH = &gkphCfg_EE_Boot_FLASH_PF;

/** Structure: TxLdoParams
 * Power management unit. \see phhalPmu_TxLdoInit and \see phhalPmu_TxLdoParams_t
 */
static const phCfg_EE_Boot_TxLdoParams_t gkphCfg_EE_Boot_TxLdoParams_PF = {
    /**
     * Parameter to use internal TxLDO or external TxLDO for TVDD Source
     * - 0 => Use external TxLDO
     * - 1 => Use internal TxLDO
     */
    .bUseTxLdo = 0x00,
    /**
     * TVDD Power Selection for Reader Mode. \see phhalPmu_TvddSel_t
     * - 0 => 3V
     * - 1 => 3.3V
     * - 2 => 3.6v
     * - 3 => 4.5V
     * - 4 => 4.7v
     * - other => Invalid
     */
    .eFullPowerTvddSel = 0x04,
    /**
     * Source for the TVDD \see phhalPmu_LowPower_TvddSrc_t
     * - 0 => Source is TVDD In
     * - 1 => Source is VUP
     * - 2 => Source is VBUS
     * - other => Invalid
     */
    .eLowPowerTvddSrc = 0x00,
    /**
     * Over Current Interrupt Enable or disable
     * - 0 => Disabled
     * - Others => Enable
     */
    .bOverCurrentEnable = 0x00,
    /**
     * [15:14] : Lfo Clock Value and [13:0] : Waiting Time after TxLdo is started. Lfo Clk = 3 and Waiting Time = 1120us.
     */
    .wWaitTime = 50272,

};
const phCfg_EE_Boot_TxLdoParams_t * const gpkphCfg_EE_Boot_TxLdoParams = &gkphCfg_EE_Boot_TxLdoParams_PF;

/** Structure: CT
 * Initial settings for CT Interface. \see phhalCt_InitParam_t
 */
static const phCfg_EE_Boot_CT_t gkphCfg_EE_Boot_CT_PF = {
    /**
     * Pull UP Configuration
     * - 0 => Pull Down
     * - 1 => Pull UP
     * - others => Undefined behaviour
     */
    .bPullUp = 0x1,
    /**
     * Connector Type
     * - 0 => Normally Closed
     * - others => Normally Open
     */
    .bConnectorType = 0x1,
    /**
     * Auto deactivation
     * - 0 => Disabled
     * - others => Enabled
     */
    .bAutoCTDeactivationEnable = 0x1,
    /**
     * CLK,IO,VCC slew rate
     * - 0 => CLK,IO,VCC slew rate
     * - others => This value is directly mapped to ct_srr_reg
                    to give enough options
     */
    .bSlewRate = 0x38,

};
const phCfg_EE_Boot_CT_t * const gpkphCfg_EE_Boot_CT = &gkphCfg_EE_Boot_CT_PF;

/** Structure: GPIO
 *
 *                     GPIO Bootup Configuration. Each byte represents a Gpio configuration starting from Gpio 1 to 12.
 *
 */
static const phCfg_EE_Boot_GPIO_t gkphCfg_EE_Boot_GPIO_PF = {
    /**
     * Lower Nibble - Related to output configuration
     *                         Upper Nibble - Related to Pull-up/Pull-down configuration
     * - Bit0=0 => Skip Configuration as output on Boot
     * - Bit0=1 => Configure Gpio as output
     * - Bit1=1 => Enable slew-rate
     * - Bit2=1 => Drive the output high
     * - Bit2=0 => Drive the output low
     * - Bit5=1 => Apply Pull UP
     * - Bit6=1 => Apply Pull Down
     */
    .OutputPUPD = {
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x03,
        0x03,
        0x07,
        0x03,
        0x03,
        0x03,
    },
    /**
     * - ALL=0 => Skip Configuration on Boot
     * - Bit0=0 => Un-Configure as input
     * - Bit0=1 => Configure/SET as Input
     * - Bit1=1 => GPIO is a wakeup source
     * - Bit2=1 => GPIO is an interrupt source
     * - Bit4=1 => Level Sensitive Interrupt
     * - Bit5=1 => Interrupt on Active Low or Falling Edge
     * - Bit6=1 => Interrupt on Both Edges
     */
    .InputISR = {
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
    },

};
const phCfg_EE_Boot_GPIO_t * const gpkphCfg_EE_Boot_GPIO = &gkphCfg_EE_Boot_GPIO_PF;

/* ****************************************************************************************************************** */
/** \name Page: HW
 * Hardware Configurations / Default settings.  These settings are not applied direclty at bootup but eventually during the course of usage of the IPs.
 */

/** Structure: WakeUpConfig
 * Wakeup Sources \see phhalPcr_WakeUpConfig_t
 */
static const phCfg_EE_HW_WakeUpConfig_t gkphCfg_EE_HW_WakeUpConfig_PF = {
    /**
     * Timer value for the wake up in milliseconds
     */
    .wWakeUpTimerVal = 300,
    /**
     * Flag to know the host interface wake up
     * - 0 => Disabled
     * - 1 => Enabled
     */
    .bEnableHIFWakeup = 0,
    /**
     * I2C address if the wake up is configured for HIF
     */
    .bI2CAddr = 0x28,
    /**
     * Flag to enable the wake up timer as wake up source
     * - 0 => Disabled
     * - 1 => Enabled
     */
    .bWakeUpTimer = 1,
    /**
     * Flag to enable the RfLdt as wake up source
     * - 0 => Disabled
     * - 1 => Enabled
     */
    .bWakeUpRfLdt = 0,
    /**
     * Flag to enable Pvdd current limitation as wake up source when it goes below the lower threshold
     * - 0 => Disabled
     * - 1 => Enabled
     */
    .bWakeUpPvddLim = 1,
    /**
     * Flag to enable CT presence as wake up source when it goes below the lower threshold
     * - 0 => Disabled
     * - 1 => Enabled
     */
    .bWakeUpCtPr = 1,
    /**
     * Flag to enable PVDD Auxiliary interrupt as wake up source when it goes below the lower threshold
     * - 0 => Disabled
     * - 1 => Enabled
     */
    .bWakeUpIntAux = 0,
    /**
     * Flag to enable Tvdd Monitoring as wake up source when it goes below the lower threshold
     * - 0 => Disabled
     * - 1 => Enabled
     */
    .bWakeUpTvddMon = 0,
    /**
     * Flag to enable Gpio as wake up source when it goes below the lower threshold
     * - 0 => Disabled
     * - 1 => Enabled
     */
    .bWakeUpGpio = 0,

};
const phCfg_EE_HW_WakeUpConfig_t * const gpkphCfg_EE_HW_WakeUpConfig = &gkphCfg_EE_HW_WakeUpConfig_PF;

/** Structure: RfAntennae
 * Antennae type. ALM or PLM
 */
static const phCfg_EE_HW_RfAntennae_t gkphCfg_EE_HW_RfAntennae_PF = {
    /**
     * - 1 => ALM is used.
     * - 0 => PLM is used.
     */
    .enableALM = 0x0,

};
const phCfg_EE_HW_RfAntennae_t * const gpkphCfg_EE_HW_RfAntennae = &gkphCfg_EE_HW_RfAntennae_PF;

/** Structure: RfInitUserEE
 * \see phhalRf_InitUserEE_t
 */
static const phCfg_EE_HW_RfInitUserEE_t gkphCfg_EE_HW_RfInitUserEE_PF = {
    /**
     * Card mode AGC Config1 value
     */
    .dwAgcConfig1CMValue = 0x0107FF7,
    /**
     * Card mode AGC Config0 value
     */
    .dwAgcConfig0CMValue = 0x44003,
    /**
     * Reference value of AGC for LPCD
     */
    .dwLCPDRefValue = 0x000020AC,
    /**
     * Threshold value for LPCD
     */
    .dwLCPDThreashold = 0x00000005,
    /**
     * Duration value for LPCD
     */
    .dwLCPDDurations = 0x00000028,
    /**
     * Card Mode most possible sensitive input value
     */
    .wAgcCMInputValue = 0x00,
    /**
     * NFC LD Threshold value
     */
    .bAnaNFCLD = 0x0C,
    /**
     * Initial value for Ana Tx Prot Register
     */
    .bAnaTxProt = 0x09,

};
const phCfg_EE_HW_RfInitUserEE_t * const gpkphCfg_EE_HW_RfInitUserEE = &gkphCfg_EE_HW_RfInitUserEE_PF;

/** Structure: RfDPC
 * \see phhalRf_DPCConfig_t
 */
static const phCfg_EE_HW_RfDPC_t gkphCfg_EE_HW_RfDPC_PF = {
    /**
     * Sets the value for the periodic regulation. Time base is 1/20Mhz. (Example: Value of 20000 is equal to 1ms)
     */
    .wControlCycle = 0x4E20,
    /**
     * Controls AGC FastMode (StepSizeEnabled: 13 + StepSize: 12..11 + DurationEnabled: 10 + Duration: 9..0 )
     */
    .wAgcFastModeConfig = 0x2540,
    /**
     * Low threashold for gearshift
     */
    .wAgcTrshLow = 0x144,
    /**
     * Guard time after AGC fast mode has been triggered. This happens in the following scenarios:
     *             - End of Receive
     *             - End of Transmit
     *             - After a gear switch
     *             Time base is 1/20MHz (Example: Value of 2000 is equal to 100us)
     */
    .wGuardTimeFastMode = 0x88B8,
    /**
     * Guard time after SoF or SC detection. This is to avoid any DPC regulation between SoF/SC and actual begin of reception. Time base is 1/20MHz (Example: Value of 2000 is equal to 100us)
     */
    .wGuardTimeSofDetected = 0x61A8,
    /**
     * Guard time after Gear Switch during FieldOn instruction. Time base is 1/20MHz (Example: Value of 2000 is equal to 100us)
     */
    .wGuardTimeFieldOn = 0x0190,
    /**
     * High threasholds for each gear
     */
    .wAgcTrshHigh = {
        0x014A,
        0x014B,
        0x014A,
        0x0148,
        0x0146,
        0x0143,
        0x013D,
        0x012E,
        0x0170,
        0x00AD,
        0x00A7,
        0x009E,
        0x0096,
        0x0087,
        0x004A,
    },
    /**
     * Control byte (StartGear: 7..4 bits + GearStep: 3..1 bits + OcProtLoopEnabled: 0 bit )
     */
    .bOcProtControl = 0x73,
    /**
     * Compensation value for the AGC
     */
    .bAgcXi = 0x0,
    /**
     * Enable/Disable debug signals
     */
    .bDebug = 0x0,
    /**
     * Shift value for AGC dynamic low threshold adjustment
     */
    .bAgcShiftValue = 0x05,
    /**
     * Number of fields in the following configuration look up table
     */
    .bSizeOfLUT = 0x09,
    /**
     * Look up table for configuration values
     */
    .bConfigLUT = {
        0xF9,
        0xF1,
        0xF3,
        0xF5,
        0xF7,
        0xF0,
        0xF2,
        0xF4,
        0xF6,
        0x96,
        0x66,
        0x46,
        0x36,
        0x26,
        0x16,
    },

};
const phCfg_EE_HW_RfDPC_t * const gpkphCfg_EE_HW_RfDPC = &gkphCfg_EE_HW_RfDPC_PF;

/** Structure: RfPcdShaping
 * \see phhalRf_PcdShapeConfig_t
 */
static const phCfg_EE_HW_RfPcdShaping_t gkphCfg_EE_HW_RfPcdShaping_PF = {
    /**
     * The lookup table for the configuration for PCD shaping.
     */
    .dwConfiguration = {
        0x08079991,
        0x00089991,
        0x17A09991,
        0x0040F991,
        0x0010B992,
        0x00209BA2,
        0x0040E9A2,
        0x00089A92,
        0x0080F992,
        0x08479093,
        0x080799A7,
        0x00089997,
        0x17309997,
        0x00014681,
        0x00104A85,
        0x00000000,
        0x00000000,
        0x00000000,
        0x00000000,
        0x00000000,
    },
    /**
     * Number of elements in the following configuration look up table.
     */
    .bSizeOfLUT = 0x2D,

};
const phCfg_EE_HW_RfPcdShaping_t * const gpkphCfg_EE_HW_RfPcdShaping = &gkphCfg_EE_HW_RfPcdShaping_PF;

/** Structure: RfAPC
 *  APC Settings
 *
 *
 */
static const phCfg_EE_HW_RfAPC_t gkphCfg_EE_HW_RfAPC_PF = {
    /**
     * Periodic timer to reapply RSSI while transceiver is in Wait4Data state. Unit is 128/fc (106kHz)
     * if set to 0 it means feature is not used
     * 0423 == ~10ms
     */
    .bRssiTimer = 0x423,
    /**
     * Size of LUT: DO NOT MODIFY this parameter
     */
    .bRssiLutSize = 0x10,
    /**
     * Number of entries in RSSI look up table (it refers to dwRssiEntry0 to dwRssiEntryX).
     * If set to 0 then no RSSI algo is applied
     */
    .bRssiNbEntries = 0x00,
    /**
     * Purpose of each bits:
     *
     * bits 26:24 = TXLDO output voltage: PMU_TXLDO_CONTROL_REG / TXLDO_SELECT
     *
     * bits 23:22 = CLIF_ANA_TX_AMPLITUDE_REG / TX_CW_AMPLITUDE_ALM_CM
     *
     * bits 21:21 = CLIF_TX_CONTROL_REG / TX_ALM_TYPE_SELECT
     *
     * bits 20:16 = CLIF_ANA_TX_AMPLITUDE_REG / TX_RESIDUAL_CARRIER
     *
     * bits 15:00 = CLIF_RSSI_REG / AGC_VALUE[15:6] + ADC_DATA_Q[5:0]
     */
    .dwRssiEntry = {
        0x84000000,
        0x009806C0,
        0x00C41180,
        0x00D81E00,
        0x00DA2580,
        0x01202F80,
        0x00243700,
        0x00AA3E80,
        0x00000000,
        0x00000000,
        0x00000000,
        0x00000000,
        0x00000000,
        0x00000000,
        0x00000000,
        0x00000000,
    },
    /**
     * Replacement of dwRssiEntry[0] for trigger ReqA/ReqB
     */
    .dwRssiEntry0overwrite = 0x03000000,

};
const phCfg_EE_HW_RfAPC_t * const gpkphCfg_EE_HW_RfAPC = &gkphCfg_EE_HW_RfAPC_PF;

/** Structure: RfInterOpTimings
 * Rf Timings for the Inter-op issues
 */
static const phCfg_EE_HW_RfInterOpTimings_t gkphCfg_EE_HW_RfInterOpTimings_PF = {
    /**
     * Value of Time(us) for Peer to turn the Rf On
     */
    .dwExtRfOnTime = 302,
    /**
     * Value of Time(us) for Peer to turn the Rf off after Transmitting data
     */
    .dwExtRfOffTime = 10,
    /**
     * Value of Time(us) for Internal Rf On in active communication
     */
    .dwIntRfOnTime = 302,
    /**
     * Value of Time(us) for RRDD for Jewel (((28 + (2 * 9.44)) + Tolerence) = 50).
     */
    .dwRRDDTime = 50,
    /**
     * Value of Time(us) for Tidt adjust to meet the spec timings of Tadt(Tadt > 768/fc(~57)).
     */
    .dwTidtTimeAdjust = 50,

};
const phCfg_EE_HW_RfInterOpTimings_t * const gpkphCfg_EE_HW_RfInterOpTimings = &gkphCfg_EE_HW_RfInterOpTimings_PF;

/** Structure: RfHalTimings
 * Rf Timings different algo.
 */
static const phCfg_EE_HW_RfHalTimings_t gkphCfg_EE_HW_RfHalTimings_PF = {
    /**
     * Time(us) for Clock Error Recovery
     */
    .dwClkErrRecoveryTime = 50,
    /**
     * Time(us) for External Rf off De-Bouncing
     */
    .dwRfOffDeBouncingTime = 20,
    /**
     * Time(us) for Pbf Alm Fw Reset Timer
     */
    .dwPbfAlmFwResetTime = 100,
    /**
     * Time(us) for Felica Stuck Timer in Card mode when SIGPRO RM is used
     */
    .dwFelicaRxRMSigproTime = 2000,

};
const phCfg_EE_HW_RfHalTimings_t * const gpkphCfg_EE_HW_RfHalTimings = &gkphCfg_EE_HW_RfHalTimings_PF;

/** Structure: DPLLCfg
 * DPLL Configurations
 */
static const phCfg_EE_HW_DPLLCfg_t gkphCfg_EE_HW_DPLLCfg_PF = {
    /**
     * Dpll Control
     */
    .DpllControl = 0x63,
    /**
     * Dpll Init
     */
    .DpllInit = 0x00171433,
    /**
     * Dpll Gear
     */
    .DpllGear = 0x00042A55,
    /**
     * Dpll Init Freq
     */
    .DpllInitFreq = 0x80008591,

};
const phCfg_EE_HW_DPLLCfg_t * const gpkphCfg_EE_HW_DPLLCfg = &gkphCfg_EE_HW_DPLLCfg_PF;

/** Structure: DPLLClkPhaseAdjustment
 * DPLL Clock Phase Adjustment Configuration
 */
static const phCfg_EE_HW_DPLLClkPhaseAdjustment_t gkphCfg_EE_HW_DPLLClkPhaseAdjustment_PF = {
    /**
     * Dpll Init value for card emulation A
     */
    .DpllInitCeA = 0x00000000,
    /**
     * Value of Ana Clk Man for card emulation A
     */
    .AnaClkManCeA = 0x00000005,
    /**
     * Dpll Init value for card emulation B
     */
    .DpllInitCeB = 0x00000000,
    /**
     * Value of Ana Clk Man for card emulation B
     */
    .AnaClkManCeB = 0x00000005,
    /**
     * Dpll Init value for card emulation F
     */
    .DpllInitCeF = 0x00000000,
    /**
     * Value of Ana Clk Man for card emulation F
     */
    .AnaClkManCeF = 0x00000005,

};
const phCfg_EE_HW_DPLLClkPhaseAdjustment_t * const gpkphCfg_EE_HW_DPLLClkPhaseAdjustment = &gkphCfg_EE_HW_DPLLClkPhaseAdjustment_PF;

/** Structure: RfLdtParams
 * \see phhalPcr_RfLdtParams_t
 */
static const phCfg_EE_HW_RfLdtParams_t gkphCfg_EE_HW_RfLdtParams_PF = {
    /**
     * Higher Reference Value for RF Level Detector
     */
    .bRfldRefLo = 2,
    /**
     * Lower Reference Value for RF Level Detector
     */
    .bRfldRefHi = 3,
    /**
     * Should we used advanced RFLD Feature or normal RFLD Feature
     */
    .bEnableAdvancedRFLD = 0,
    /**
     * Structure padding.
     */
    .bPadding = 0,

};
const phCfg_EE_HW_RfLdtParams_t * const gpkphCfg_EE_HW_RfLdtParams = &gkphCfg_EE_HW_RfLdtParams_PF;

/** Structure: RfTestBus
 * Test Bus configuration of RF
 */
static const phCfg_EE_HW_RfTestBus_t gkphCfg_EE_HW_RfTestBus_PF = {
    /**
     * 0x00: No Analog Test Bus Signal Enabled
     */
    .dwAnaTB = 0x00000000,
    /**
     * 0x00 :  No Analog Test Bus Signal Enabled
     */
    .dwDAC = 0x00000000,
    /**
     * 0x02 : Tx Active
     */
    .bTbDigi1 = 0x02,
    /**
     * 0x00 : No Digital Test Bus Signal2 Enabled
     */
    .bTbDigi2 = 0x00,

};
const phCfg_EE_HW_RfTestBus_t * const gpkphCfg_EE_HW_RfTestBus = &gkphCfg_EE_HW_RfTestBus_PF;

/** Structure: ClkGenClifClockStart
 * Configuration for ClkGen to start Clif Clock
 */
static const phCfg_EE_HW_ClkGenClifClockStart_t gkphCfg_EE_HW_ClkGenClifClockStart_PF = {
    /**
     * Value of Ana Clk field for Passive Reader Mode
     */
    .ClkModePassiveRm = 0x00,
    /**
     * Value of Ana Clk field for Active Mode
     */
    .ClkModeActive = 0x10,
    /**
     * Value of Ana Clk field for PLM Card Mode
     */
    .ClkModePlmCm = 0x50,
    /**
     * Value of Ana Clk field for Alm Card Mode
     */
    .ClkModeAlmCm = 0x50,

};
const phCfg_EE_HW_ClkGenClifClockStart_t * const gpkphCfg_EE_HW_ClkGenClifClockStart = &gkphCfg_EE_HW_ClkGenClifClockStart_PF;

/** Structure: I2CM
 * Default configuration for I2C Master. These values are primarily used for phExHif.
 */
static const phCfg_EE_HW_I2CM_t gkphCfg_EE_HW_I2CM_PF = {
    /**
     * I2C Master transaction data rate in Hz.
     */
    .dwDataRateHz = 100000,
    /**
     * I2C 7-bit slave address.
     */
    .bSlaveAddr = 0x28,

};
const phCfg_EE_HW_I2CM_t * const gpkphCfg_EE_HW_I2CM = &gkphCfg_EE_HW_I2CM_PF;

/** Structure: SPIM
 * SPI Master configurations
 */
static const phCfg_EE_HW_SPIM_t gkphCfg_EE_HW_SPIM_PF = {
    /**
     * Specifies the SPIM mode (CPOL, CPHA) of operation, \see phhalSPIM_Modes_t.
     */
    .bModes = 0x00,
    /**
     * Specifies the SPIM transaction data rate. \see phhalSPIM_Configure
     * - 0 => 1.0 MHz
     * - 1 => 1.51 MHz
     * - 2 => 2.09 MHz
     * - 3 => 2.47 MHz
     * - 4 => 3.01 MHz
     * - 5 => 4.52 MHz
     * - 6 => 5.42 MHz
     * - 7 => 6.78 MHz
     */
    .bDataRate = 0x00,

};
const phCfg_EE_HW_SPIM_t * const gpkphCfg_EE_HW_SPIM = &gkphCfg_EE_HW_SPIM_PF;

/** Structure: HIF
 * Host interface configurations. These values are primarily used for phExHif.
 */
static const phCfg_EE_HW_HIF_t gkphCfg_EE_HW_HIF_PF = {
    /**
     * Hif interfaces like I2C, SPI, HSU, USB or disabled.
     * - 0 => Disabled
     * - 1 => I2C
     * - 2 => SPI
     * - 3 => HSU
     * - 4 => USB
     */
    .bInterface = 0x1,
    /**
     * Refer phhalHif_Config_t->sI2cConfig in Hif module.
     */
    .bI2cConfig = 0x00,
    /**
     * Refer phhalHif_Config_t->sSpiConfig in Hif module.
     */
    .bSpiConfig = 0x00,
    /**
     * Set the Hsu Wakeup simulation.
     */
    .bIsHsuBoot = 0x00,
    /**
     * Hsu Eof size - Maximum interbyte duration.
     */
    .bEndOfFrame = 0x00,
    /**
     * Number of Hsu stop bits.
     */
    .bStopBits = 0x00,
    /**
     * Number of Dummy bytes, used during standby phase.
     */
    .bDummyBytes = 0x00,
    /**
     * Refer phhalHif_Hsu_BaudRate_t.
     */
    .bBaudRate = 0x00,
    /**
     * Hif interfaces like I2C, SPI, HSU, USB or disabled.
     * - 0 => E_BUFFER_FORMAT_FREE, transparent (generic HW protocol format).
     * - 1 => E_BUFFER_FORMAT_FIXED, Header + Payload + Crc.
     * - 2 => E_BUFFER_FORMAT_NATIVE, transparent with Size at 1st Word.
     */
    .bBufferType = 0x0,
    /**
     * Number of bytes representing ShortFrame.
     */
    .bShortFrameLen = 0x00,
    /**
     * Store error data or discard error data.
     * - 0 => Disabled
     * - 1 => Enabled
     */
    .bStoreErrData = 0x00,
    /**
     * Header Size in Fixed Format.
     */
    .bHeaderSize = 0x00,
    /**
     * Inter character Tx Timeout in steps of 3.6us.
     */
    .bTimeout = 0x00,
    /**
     * If the user board takes more time than expected to detect discharge during self power mode,
     * user can set this bit to discharge faster. There is a possibility of performance improvement
     * of detecting USB disconnected based on PULLDOWN enabled/disabled.
     */
    .bEnableVBUSPullDown = 0x00,

};
const phCfg_EE_HW_HIF_t * const gpkphCfg_EE_HW_HIF = &gkphCfg_EE_HW_HIF_PF;

/* ****************************************************************************************************************** */
/** \name Page: phRFLP
 *
        Values for RF Load Protocol based on:

<pre>

               Name : 65x65_PLM_MRA3
            Antenna : 65x65 PLM
      Last Modified : 2/1/2016
        Last Author : Maniraj Ashirwad G
     Version Number : Comments
               V1.0 : Initial Version. Changes in this excel sheet and user_ee_65x65.xml &  should be logged further. User_ee.xml should be same as user_ee_65x65.xml while generating the eeprom for 65x65 Antenna.
               V1.1 : DYNAMIC_BPSK_TH_ENABLE - Enabled for Felica Reader Mode Passive Initiator 212 and 424
    CLIF_ANA_CLK_MAN_REG - Register Value added for Felica Passive CM transition (For ALM :  GTM and Felica values are different)
               V1.2 : All the test bus signal are disable except TX_ACTIVE on Digital Test Bus 1 (GPIO4) in user_ee_65x65_5V.xml
               V1.3 : For Type A RM 848   in CLIF_ANA_TX_SHAPE_CONTROL_REG register   TX_SET_TAU_MOD_FALLING   TX_SET_TAU_MOD_RISING are changed for RM A-848 fixing ISO OverShoot Failure
    For Type A RM 848 :  in CLIF_ANA_TX_AMPLITUDE_REG register   TX_GSN_MOD_RM is changed to fix ISO Overshoot Failure.
              V1.4  : Integration with the excel sheet PN5180_RF_ConfigurationSnapshot_20151103
              V1.5  : 1. Bug Fix - SC3871
    2. Bit Fields of "CLIF_SIGPRO_ADCBCM_CONFIG_REG" :  are updated with MRA2 Bit Fields
             V1.5.1 : 1. Bug Fix - Type B update for "CLIF_TX_SYMBOL1_DEF_REG"
             V1.5.2 : Bug Fix - SC3897. TX_CW_AMP_REF2TVDD is set to '0' in the boot settings
               V1.6 : Integration with the PN5180 Eeprom Configuration "PN5180 FW RC4 release - V0.143".
                    : Register Changes:
                    : CLIF_ANA_RX_REG -  A212, A424,A848, B424, B848, 1800 - 18.88 SC424 2M, 1800 - 18.88 SC424 4M, 1800 - 18.88 SC848 2M,1800 - 18.88 SC848 4M, 1800 - 9.44 SC424 2M, 1800 - 9.44 SC424 4M, 1800 - 9.44 SC848 2M, 1800 - 9.44 SC848 4M
                    :
                    : CLIF_SIGPRO_RM_CONFIG1_REG - A212, A424, A848, B212, B424, B848,1800 - 18.88 SC424 2M, 1800 - 18.88 SC424 4M, 1800 - 9.44 SC424 2M, 1800 - 9.44 SC424 4M
               V1.7 : No update - Created by Purnank
             V1.7.1 : TXOCP configuration update for 65x65 <4v. Agc Ref = 220
             V1.7.2 : CLIF_SIGPRO_ADCBCM_CONFIG_REG configuration update based for MRA2 Addition bit fields.
    CLIF_SIGPRO_ADCBCM_CONFIG_REG - GTM : CM - A106   A212   A424   A848   F212   F424   AI 212   AI 424
             V1.7.3 : PCD Shaping configuration update for 65x65
             V1.7.4 : Renaming of TxOCP to DPC (eeprom xml files)
               V1.8 : Separate PCD configuration added for <4v and >4v configuration
             V1.8.1 : CLIF_ANA_NFCLD_REG value is updated - Initiator.
    EDGE_DETECT_TAP_SEL updated for Type A 424 :  848 CM - Target
             V1.8.2 : CLIF_ANA_NFCLD_REG set to 0x0C
             V1.8.3 : CLIF_ANA_NFCLD_REG set to 0x07
               V1.9 : 1. CLIF_TEST_CONTROL_REG added to the Initiator Tab
             V1.9.1 : Change for 30x50mm 5V DPC Config (AGC Hi Threshold) no change for 65x65mm
             V1.9.2 : CLIF_ANA_NFCLD_REG set to 0x1C in boot setting
</pre>

    Generated from clifcsv_to_xml.py version 2016.01.21_00 on 2019-11-13
 */

/** Structure: T_Tx_val
 *
 *             Value to be applied to the corresponding CLIF register for CLIF Target Mode - Transmit.
 *
 */
static const phCfg_EE_phRFLP_T_Tx_val_t gkphCfg_EE_phRFLP_T_Tx_val_PF = {
    /**
     * Value for Register CLIF_TRANSCEIVE_CONTROL_REG.
     *
     * Note: Configuration: T_TX_GTM starts from here.
     */
    .u32_T_TX_GTM_00_TRANSCEIVE_CONTROL_REG = 0x7200,
    /**
     * Value for Register CLIF_ANA_PBF_CONTROL_REG.
     */
    .u32_T_TX_GTM_01_ANA_PBF_CONTROL_REG = 0x2c,
    /**
     * Value for Register CLIF_ANA_TX_AMPLITUDE_REG.
     */
    .u32_T_TX_GTM_02_ANA_TX_AMPLITUDE_REG = 0xffff4000,
    /**
     * Value for Register CLIF_ANA_TX_CLK_CONTROL_REG.
     */
    .u32_T_TX_GTM_03_ANA_TX_CLK_CONTROL_REG = 0x1,
    /**
     * Value for Register CLIF_TX_UNDERSHOOT_CONFIG_REG.
     */
    .u32_T_TX_GTM_04_TX_UNDERSHOOT_CONFIG_REG = 0x0,
    /**
     * Value for Register CLIF_TX_OVERSHOOT_CONFIG_REG.
     */
    .u32_T_TX_GTM_05_TX_OVERSHOOT_CONFIG_REG = 0x0,
    /**
     * Value for Register CLIF_ANA_TX_SHAPE_CONTROL_REG.
     */
    .u32_T_TX_GTM_06_ANA_TX_SHAPE_CONTROL_REG = 0x0,
    /**
     * Value for Register CLIF_TX_CONTROL_REG.
     */
    .u32_T_TX_GTM_07_TX_CONTROL_REG = 0x0,
    /**
     * Value for Register CLIF_ANA_CLK_MAN_REG.
     */
    .u32_T_TX_GTM_08_ANA_CLK_MAN_REG = 0x10,
    /**
     * Value for Register CLIF_TRANSCEIVE_CONTROL_REG.
     *
     * Note: Configuration: T_TX_A_106_P starts from here.
     */
    .u32_T_TX_A_106_P_00_TRANSCEIVE_CONTROL_REG = 0x7202,
    /**
     * Value for Register CLIF_TX_UNDERSHOOT_CONFIG_REG.
     */
    .u32_T_TX_A_106_P_01_TX_UNDERSHOOT_CONFIG_REG = 0x0,
    /**
     * Value for Register CLIF_TX_OVERSHOOT_CONFIG_REG.
     */
    .u32_T_TX_A_106_P_02_TX_OVERSHOOT_CONFIG_REG = 0x0,
    /**
     * Value for Register CLIF_TRANSCEIVE_CONTROL_REG.
     *
     * Note: Configuration: T_TX_A_212 starts from here.
     */
    .u32_T_TX_A_212_00_TRANSCEIVE_CONTROL_REG = 0x7202,
    /**
     * Value for Register CLIF_TX_UNDERSHOOT_CONFIG_REG.
     */
    .u32_T_TX_A_212_01_TX_UNDERSHOOT_CONFIG_REG = 0x0,
    /**
     * Value for Register CLIF_TX_OVERSHOOT_CONFIG_REG.
     */
    .u32_T_TX_A_212_02_TX_OVERSHOOT_CONFIG_REG = 0x0,
    /**
     * Value for Register CLIF_TRANSCEIVE_CONTROL_REG.
     *
     * Note: Configuration: T_TX_A_424 starts from here.
     */
    .u32_T_TX_A_424_00_TRANSCEIVE_CONTROL_REG = 0x7202,
    /**
     * Value for Register CLIF_TX_UNDERSHOOT_CONFIG_REG.
     */
    .u32_T_TX_A_424_01_TX_UNDERSHOOT_CONFIG_REG = 0x0,
    /**
     * Value for Register CLIF_TX_OVERSHOOT_CONFIG_REG.
     */
    .u32_T_TX_A_424_02_TX_OVERSHOOT_CONFIG_REG = 0x0,
    /**
     * Value for Register CLIF_TRANSCEIVE_CONTROL_REG.
     *
     * Note: Configuration: T_TX_A_848 starts from here.
     */
    .u32_T_TX_A_848_00_TRANSCEIVE_CONTROL_REG = 0x7202,
    /**
     * Value for Register CLIF_TX_UNDERSHOOT_CONFIG_REG.
     */
    .u32_T_TX_A_848_01_TX_UNDERSHOOT_CONFIG_REG = 0x0,
    /**
     * Value for Register CLIF_TX_OVERSHOOT_CONFIG_REG.
     */
    .u32_T_TX_A_848_02_TX_OVERSHOOT_CONFIG_REG = 0x0,
    /**
     * Value for Register CLIF_TRANSCEIVE_CONTROL_REG.
     *
     * Note: Configuration: T_TX_F_P starts from here.
     */
    .u32_T_TX_F_P_00_TRANSCEIVE_CONTROL_REG = 0x0,
    /**
     * Value for Register CLIF_ANA_TX_AMPLITUDE_REG.
     */
    .u32_T_TX_F_P_01_ANA_TX_AMPLITUDE_REG = 0xffff4000,
    /**
     * Value for Register CLIF_TX_UNDERSHOOT_CONFIG_REG.
     */
    .u32_T_TX_F_P_02_TX_UNDERSHOOT_CONFIG_REG = 0x0,
    /**
     * Value for Register CLIF_TX_OVERSHOOT_CONFIG_REG.
     */
    .u32_T_TX_F_P_03_TX_OVERSHOOT_CONFIG_REG = 0x0,
    /**
     * Value for Register CLIF_ANA_CLK_MAN_REG.
     */
    .u32_T_TX_F_P_04_ANA_CLK_MAN_REG = 0x10,
    /**
     * Value for Register CLIF_ANA_PBF_CONTROL_REG.
     *
     * Note: Configuration: T_TX_ACT starts from here.
     */
    .u32_T_TX_ACT_00_ANA_PBF_CONTROL_REG = 0xa0,
    /**
     * Value for Register CLIF_TX_CONTROL_REG.
     */
    .u32_T_TX_ACT_01_TX_CONTROL_REG = 0x0,
    /**
     * Value for Register CLIF_ANA_CLK_MAN_REG.
     */
    .u32_T_TX_ACT_02_ANA_CLK_MAN_REG = 0x10,
    /**
     * Value for Register CLIF_TRANSCEIVE_CONTROL_REG.
     *
     * Note: Configuration: T_TX_A_106_ACT starts from here.
     */
    .u32_T_TX_A_106_ACT_00_TRANSCEIVE_CONTROL_REG = 0x35002,
    /**
     * Value for Register CLIF_ANA_TX_AMPLITUDE_REG.
     */
    .u32_T_TX_A_106_ACT_01_ANA_TX_AMPLITUDE_REG = 0xffff50f4,
    /**
     * Value for Register CLIF_ANA_TX_CLK_CONTROL_REG.
     */
    .u32_T_TX_A_106_ACT_02_ANA_TX_CLK_CONTROL_REG = 0x783,
    /**
     * Value for Register CLIF_TX_UNDERSHOOT_CONFIG_REG.
     */
    .u32_T_TX_A_106_ACT_03_TX_UNDERSHOOT_CONFIG_REG = 0x17,
    /**
     * Value for Register CLIF_TX_OVERSHOOT_CONFIG_REG.
     */
    .u32_T_TX_A_106_ACT_04_TX_OVERSHOOT_CONFIG_REG = 0x0,
    /**
     * Value for Register CLIF_ANA_TX_SHAPE_CONTROL_REG.
     */
    .u32_T_TX_A_106_ACT_05_ANA_TX_SHAPE_CONTROL_REG = 0x1b000f43,
    /**
     * Value for Register CLIF_TX_DATA_MOD_REG.
     */
    .u32_T_TX_A_106_ACT_06_TX_DATA_MOD_REG = 0x230104,
    /**
     * Value for Register CLIF_TX_SYMBOL23_MOD_REG.
     */
    .u32_T_TX_A_106_ACT_07_TX_SYMBOL23_MOD_REG = 0x260104,
    /**
     * Value for Register CLIF_TX_SYMBOL01_MOD_REG.
     */
    .u32_T_TX_A_106_ACT_08_TX_SYMBOL01_MOD_REG = 0x230104,
    /**
     * Value for Register CLIF_TRANSCEIVE_CONTROL_REG.
     *
     * Note: Configuration: T_TX_F_212_ACT starts from here.
     */
    .u32_T_TX_F_212_ACT_00_TRANSCEIVE_CONTROL_REG = 0x30000,
    /**
     * Value for Register CLIF_ANA_TX_AMPLITUDE_REG.
     */
    .u32_T_TX_F_212_ACT_01_ANA_TX_AMPLITUDE_REG = 0xffff507c,
    /**
     * Value for Register CLIF_ANA_TX_CLK_CONTROL_REG.
     */
    .u32_T_TX_F_212_ACT_02_ANA_TX_CLK_CONTROL_REG = 0x8f,
    /**
     * Value for Register CLIF_TX_UNDERSHOOT_CONFIG_REG.
     */
    .u32_T_TX_F_212_ACT_03_TX_UNDERSHOOT_CONFIG_REG = 0x0,
    /**
     * Value for Register CLIF_TX_OVERSHOOT_CONFIG_REG.
     */
    .u32_T_TX_F_212_ACT_04_TX_OVERSHOOT_CONFIG_REG = 0x0,
    /**
     * Value for Register CLIF_ANA_TX_SHAPE_CONTROL_REG.
     */
    .u32_T_TX_F_212_ACT_05_ANA_TX_SHAPE_CONTROL_REG = 0x7010744,
    /**
     * Value for Register CLIF_TX_DATA_MOD_REG.
     */
    .u32_T_TX_F_212_ACT_06_TX_DATA_MOD_REG = 0x15,
    /**
     * Value for Register CLIF_TX_SYMBOL01_MOD_REG.
     */
    .u32_T_TX_F_212_ACT_07_TX_SYMBOL01_MOD_REG = 0x15,
    /**
     * Value for Register CLIF_TRANSCEIVE_CONTROL_REG.
     *
     * Note: Configuration: T_TX_F_424_ACT starts from here.
     */
    .u32_T_TX_F_424_ACT_00_TRANSCEIVE_CONTROL_REG = 0x30000,
    /**
     * Value for Register CLIF_ANA_TX_AMPLITUDE_REG.
     */
    .u32_T_TX_F_424_ACT_01_ANA_TX_AMPLITUDE_REG = 0xffff507c,
    /**
     * Value for Register CLIF_ANA_TX_CLK_CONTROL_REG.
     */
    .u32_T_TX_F_424_ACT_02_ANA_TX_CLK_CONTROL_REG = 0x8f,
    /**
     * Value for Register CLIF_TX_UNDERSHOOT_CONFIG_REG.
     */
    .u32_T_TX_F_424_ACT_03_TX_UNDERSHOOT_CONFIG_REG = 0x0,
    /**
     * Value for Register CLIF_TX_OVERSHOOT_CONFIG_REG.
     */
    .u32_T_TX_F_424_ACT_04_TX_OVERSHOOT_CONFIG_REG = 0x0,
    /**
     * Value for Register CLIF_ANA_TX_SHAPE_CONTROL_REG.
     */
    .u32_T_TX_F_424_ACT_05_ANA_TX_SHAPE_CONTROL_REG = 0x7010f33,
    /**
     * Value for Register CLIF_TX_DATA_MOD_REG.
     */
    .u32_T_TX_F_424_ACT_06_TX_DATA_MOD_REG = 0x16,
    /**
     * Value for Register CLIF_TX_SYMBOL01_MOD_REG.
     */
    .u32_T_TX_F_424_ACT_07_TX_SYMBOL01_MOD_REG = 0x16,
    /**
     * Value for Register CLIF_ANA_TX_AMPLITUDE_REG.
     *
     * Note: Configuration: T_TX_B starts from here.
     */
    .u32_T_TX_B_00_ANA_TX_AMPLITUDE_REG = 0xffff0000,

};
const phCfg_EE_phRFLP_T_Tx_val_t * const gpkphCfg_EE_phRFLP_T_Tx_val = &gkphCfg_EE_phRFLP_T_Tx_val_PF;

/** Structure: T_Rx_val
 *
 *             Value to be applied to the corresponding CLIF register for CLIF Target Mode - Receive.
 *
 */
static const phCfg_EE_phRFLP_T_Rx_val_t gkphCfg_EE_phRFLP_T_Rx_val_PF = {
    /**
     * Value for Register CLIF_ANA_RX_REG.
     *
     * Note: Configuration: T_RX_GTM starts from here.
     */
    .u32_T_RX_GTM_00_ANA_RX_REG = 0x390a3,
    /**
     * Value for Register CLIF_ANA_AGC_REG.
     */
    .u32_T_RX_GTM_01_ANA_AGC_REG = 0x2,
    /**
     * Value for Register CLIF_AGC_CONFIG1_REG.
     */
    .u32_T_RX_GTM_02_AGC_CONFIG1_REG = 0x10207ff7,
    /**
     * Value for Register CLIF_AGC_CONFIG0_REG.
     */
    .u32_T_RX_GTM_03_AGC_CONFIG0_REG = 0x4003,
    /**
     * Value for Register CLIF_AGC_INPUT_REG.
     */
    .u32_T_RX_GTM_04_AGC_INPUT_REG = 0x3000150,
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_THRESHOLD_REG.
     */
    .u32_T_RX_GTM_05_SIGPRO_ADCBCM_THRESHOLD_REG = 0x80060,
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_CONFIG_REG.
     */
    .u32_T_RX_GTM_06_SIGPRO_ADCBCM_CONFIG_REG = 0xf809d0d,
    /**
     * Value for Register CLIF_ANA_CM_CONFIG_REG.
     */
    .u32_T_RX_GTM_07_ANA_CM_CONFIG_REG = 0x4080,
    /**
     * Value for Register CLIF_SIGPRO_CM_CONFIG_REG.
     */
    .u32_T_RX_GTM_08_SIGPRO_CM_CONFIG_REG = 0x6b40,
    /**
     * Value for Register CLIF_SIGPRO_RM_CONFIG1_REG.
     */
    .u32_T_RX_GTM_09_SIGPRO_RM_CONFIG1_REG = 0x10ccc05,
    /**
     * Value for Register CLIF_BBA_CONTROL_REG.
     */
    .u32_T_RX_GTM_10_BBA_CONTROL_REG = 0x0,
    /**
     * Value for Register CLIF_SIGPRO_RM_CONFIG1_REG.
     *
     * Note: Configuration: T_RX_A starts from here.
     */
    .u32_T_RX_A_00_SIGPRO_RM_CONFIG1_REG = 0x0,
    /**
     * Value for Register CLIF_ANA_RX_REG.
     *
     * Note: Configuration: T_RX_A_106 starts from here.
     */
    .u32_T_RX_A_106_00_ANA_RX_REG = 0x390a3,
    /**
     * Value for Register CLIF_AGC_CONFIG1_REG.
     */
    .u32_T_RX_A_106_01_AGC_CONFIG1_REG = 0x10207ff7,
    /**
     * Value for Register CLIF_AGC_CONFIG0_REG.
     */
    .u32_T_RX_A_106_02_AGC_CONFIG0_REG = 0x44003,
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_THRESHOLD_REG.
     */
    .u32_T_RX_A_106_03_SIGPRO_ADCBCM_THRESHOLD_REG = 0x4003c,
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_CONFIG_REG.
     */
    .u32_T_RX_A_106_04_SIGPRO_ADCBCM_CONFIG_REG = 0x180f9ed,
    /**
     * Value for Register CLIF_ANA_CM_CONFIG_REG.
     */
    .u32_T_RX_A_106_05_ANA_CM_CONFIG_REG = 0x4080,
    /**
     * Value for Register CLIF_SIGPRO_CM_CONFIG_REG.
     */
    .u32_T_RX_A_106_06_SIGPRO_CM_CONFIG_REG = 0x944,
    /**
     * Value for Register CLIF_BBA_CONTROL_REG.
     */
    .u32_T_RX_A_106_07_BBA_CONTROL_REG = 0x0,
    /**
     * Value for Register CLIF_ANA_RX_REG.
     *
     * Note: Configuration: T_RX_A_212 starts from here.
     */
    .u32_T_RX_A_212_00_ANA_RX_REG = 0x390a3,
    /**
     * Value for Register CLIF_AGC_CONFIG1_REG.
     */
    .u32_T_RX_A_212_01_AGC_CONFIG1_REG = 0x10207ff7,
    /**
     * Value for Register CLIF_AGC_CONFIG0_REG.
     */
    .u32_T_RX_A_212_02_AGC_CONFIG0_REG = 0x44003,
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_THRESHOLD_REG.
     */
    .u32_T_RX_A_212_03_SIGPRO_ADCBCM_THRESHOLD_REG = 0x3000e0,
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_CONFIG_REG.
     */
    .u32_T_RX_A_212_04_SIGPRO_ADCBCM_CONFIG_REG = 0x880f9ef,
    /**
     * Value for Register CLIF_ANA_CM_CONFIG_REG.
     */
    .u32_T_RX_A_212_05_ANA_CM_CONFIG_REG = 0x7080,
    /**
     * Value for Register CLIF_SIGPRO_CM_CONFIG_REG.
     */
    .u32_T_RX_A_212_06_SIGPRO_CM_CONFIG_REG = 0x944,
    /**
     * Value for Register CLIF_BBA_CONTROL_REG.
     */
    .u32_T_RX_A_212_07_BBA_CONTROL_REG = 0x0,
    /**
     * Value for Register CLIF_ANA_RX_REG.
     *
     * Note: Configuration: T_RX_A_424 starts from here.
     */
    .u32_T_RX_A_424_00_ANA_RX_REG = 0x390a3,
    /**
     * Value for Register CLIF_AGC_CONFIG1_REG.
     */
    .u32_T_RX_A_424_01_AGC_CONFIG1_REG = 0x10207ff7,
    /**
     * Value for Register CLIF_AGC_CONFIG0_REG.
     */
    .u32_T_RX_A_424_02_AGC_CONFIG0_REG = 0x44003,
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_THRESHOLD_REG.
     */
    .u32_T_RX_A_424_03_SIGPRO_ADCBCM_THRESHOLD_REG = 0x200040,
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_CONFIG_REG.
     */
    .u32_T_RX_A_424_04_SIGPRO_ADCBCM_CONFIG_REG = 0x8805d0f,
    /**
     * Value for Register CLIF_ANA_CM_CONFIG_REG.
     */
    .u32_T_RX_A_424_05_ANA_CM_CONFIG_REG = 0x4080,
    /**
     * Value for Register CLIF_SIGPRO_CM_CONFIG_REG.
     */
    .u32_T_RX_A_424_06_SIGPRO_CM_CONFIG_REG = 0x1144,
    /**
     * Value for Register CLIF_BBA_CONTROL_REG.
     */
    .u32_T_RX_A_424_07_BBA_CONTROL_REG = 0x0,
    /**
     * Value for Register CLIF_ANA_RX_REG.
     *
     * Note: Configuration: T_RX_A_848 starts from here.
     */
    .u32_T_RX_A_848_00_ANA_RX_REG = 0x390af,
    /**
     * Value for Register CLIF_AGC_CONFIG1_REG.
     */
    .u32_T_RX_A_848_01_AGC_CONFIG1_REG = 0x10207ff7,
    /**
     * Value for Register CLIF_AGC_CONFIG0_REG.
     */
    .u32_T_RX_A_848_02_AGC_CONFIG0_REG = 0x44003,
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_THRESHOLD_REG.
     */
    .u32_T_RX_A_848_03_SIGPRO_ADCBCM_THRESHOLD_REG = 0x180040,
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_CONFIG_REG.
     */
    .u32_T_RX_A_848_04_SIGPRO_ADCBCM_CONFIG_REG = 0x41101e71,
    /**
     * Value for Register CLIF_ANA_CM_CONFIG_REG.
     */
    .u32_T_RX_A_848_05_ANA_CM_CONFIG_REG = 0x4080,
    /**
     * Value for Register CLIF_SIGPRO_CM_CONFIG_REG.
     */
    .u32_T_RX_A_848_06_SIGPRO_CM_CONFIG_REG = 0x1144,
    /**
     * Value for Register CLIF_BBA_CONTROL_REG.
     */
    .u32_T_RX_A_848_07_BBA_CONTROL_REG = 0x0,
    /**
     * Value for Register CLIF_ANA_RX_REG.
     *
     * Note: Configuration: T_RX_F starts from here.
     */
    .u32_T_RX_F_00_ANA_RX_REG = 0x390a3,
    /**
     * Value for Register CLIF_AGC_CONFIG1_REG.
     */
    .u32_T_RX_F_01_AGC_CONFIG1_REG = 0x207ff6,
    /**
     * Value for Register CLIF_AGC_CONFIG0_REG.
     */
    .u32_T_RX_F_02_AGC_CONFIG0_REG = 0x4400b,
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_THRESHOLD_REG.
     */
    .u32_T_RX_F_03_SIGPRO_ADCBCM_THRESHOLD_REG = 0x80060,
    /**
     * Value for Register CLIF_BBA_CONTROL_REG.
     */
    .u32_T_RX_F_04_BBA_CONTROL_REG = 0x0,
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_CONFIG_REG.
     *
     * Note: Configuration: T_RX_F_212 starts from here.
     */
    .u32_T_RX_F_212_00_SIGPRO_ADCBCM_CONFIG_REG = 0xf80ad05,
    /**
     * Value for Register CLIF_SIGPRO_CM_CONFIG_REG.
     */
    .u32_T_RX_F_212_01_SIGPRO_CM_CONFIG_REG = 0x6206,
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_CONFIG_REG.
     *
     * Note: Configuration: T_RX_F_424 starts from here.
     */
    .u32_T_RX_F_424_00_SIGPRO_ADCBCM_CONFIG_REG = 0xf80ad09,
    /**
     * Value for Register CLIF_SIGPRO_CM_CONFIG_REG.
     */
    .u32_T_RX_F_424_01_SIGPRO_CM_CONFIG_REG = 0x6206,
    /**
     * Value for Register CLIF_AGC_CONFIG1_REG.
     *
     * Note: Configuration: T_RX_ACT starts from here.
     */
    .u32_T_RX_ACT_00_AGC_CONFIG1_REG = 0x207ff6,
    /**
     * Value for Register CLIF_AGC_CONFIG0_REG.
     */
    .u32_T_RX_ACT_01_AGC_CONFIG0_REG = 0x4400b,
    /**
     * Value for Register CLIF_SIGPRO_CM_CONFIG_REG.
     *
     * Note: Configuration: T_RX_A_106_ACT starts from here.
     */
    .u32_T_RX_A_106_ACT_00_SIGPRO_CM_CONFIG_REG = 0x104,
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_THRESHOLD_REG.
     *
     * Note: Configuration: T_RX_F_212_ACT starts from here.
     */
    .u32_T_RX_F_212_ACT_00_SIGPRO_ADCBCM_THRESHOLD_REG = 0x80060,
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_CONFIG_REG.
     */
    .u32_T_RX_F_212_ACT_01_SIGPRO_ADCBCM_CONFIG_REG = 0xf801c85,
    /**
     * Value for Register CLIF_SIGPRO_CM_CONFIG_REG.
     */
    .u32_T_RX_F_212_ACT_02_SIGPRO_CM_CONFIG_REG = 0x6206,
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_THRESHOLD_REG.
     *
     * Note: Configuration: T_RX_F_424_ACT starts from here.
     */
    .u32_T_RX_F_424_ACT_00_SIGPRO_ADCBCM_THRESHOLD_REG = 0x80060,
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_CONFIG_REG.
     */
    .u32_T_RX_F_424_ACT_01_SIGPRO_ADCBCM_CONFIG_REG = 0xf801c89,
    /**
     * Value for Register CLIF_SIGPRO_CM_CONFIG_REG.
     */
    .u32_T_RX_F_424_ACT_02_SIGPRO_CM_CONFIG_REG = 0x6206,
    /**
     * Value for Register CLIF_ANA_RX_REG.
     *
     * Note: Configuration: T_RX_B starts from here.
     */
    .u32_T_RX_B_00_ANA_RX_REG = 0x390a3,
    /**
     * Value for Register CLIF_BBA_CONTROL_REG.
     */
    .u32_T_RX_B_01_BBA_CONTROL_REG = 0x341,
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_THRESHOLD_REG.
     *
     * Note: Configuration: T_RX_B_106 starts from here.
     */
    .u32_T_RX_B_106_00_SIGPRO_ADCBCM_THRESHOLD_REG = 0x6400c8,
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_CONFIG_REG.
     */
    .u32_T_RX_B_106_01_SIGPRO_ADCBCM_CONFIG_REG = 0x1780adef,
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_THRESHOLD_REG.
     *
     * Note: Configuration: T_RX_B_212 starts from here.
     */
    .u32_T_RX_B_212_00_SIGPRO_ADCBCM_THRESHOLD_REG = 0x6400c8,
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_CONFIG_REG.
     */
    .u32_T_RX_B_212_01_SIGPRO_ADCBCM_CONFIG_REG = 0x17805def,
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_THRESHOLD_REG.
     *
     * Note: Configuration: T_RX_B_424 starts from here.
     */
    .u32_T_RX_B_424_00_SIGPRO_ADCBCM_THRESHOLD_REG = 0x6400c8,
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_CONFIG_REG.
     */
    .u32_T_RX_B_424_01_SIGPRO_ADCBCM_CONFIG_REG = 0x17805def,
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_THRESHOLD_REG.
     *
     * Note: Configuration: T_RX_B_848 starts from here.
     */
    .u32_T_RX_B_848_00_SIGPRO_ADCBCM_THRESHOLD_REG = 0x6400a8,
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_CONFIG_REG.
     */
    .u32_T_RX_B_848_01_SIGPRO_ADCBCM_CONFIG_REG = 0x17805c71,

};
const phCfg_EE_phRFLP_T_Rx_val_t * const gpkphCfg_EE_phRFLP_T_Rx_val = &gkphCfg_EE_phRFLP_T_Rx_val_PF;

/** Structure: I_Tx_val
 *
 *             Value to be applied to the corresponding CLIF register for CLIF Initiator Mode - Transmit.
 *
 */
static const phCfg_EE_phRFLP_I_Tx_val_t gkphCfg_EE_phRFLP_I_Tx_val_PF = {
    /**
     * Value for Register CLIF_ANA_PBF_CONTROL_REG.
     *
     * Note: Configuration: I_TX starts from here.
     */
    .u32_I_TX_00_ANA_PBF_CONTROL_REG = 0xa0,
    /**
     * Value for Register CLIF_TRANSCEIVE_CONTROL_REG.
     *
     * Note: Configuration: I_TX_A starts from here.
     */
    .u32_I_TX_A_00_TRANSCEIVE_CONTROL_REG = 0x5041,
    /**
     * Value for Register CLIF_ANA_TX_AMPLITUDE_REG.
     *
     * Note: Configuration: I_TX_A_106 starts from here.
     */
    .u32_I_TX_A_106_00_ANA_TX_AMPLITUDE_REG = 0xffff50f4,
    /**
     * Value for Register CLIF_ANA_TX_CLK_CONTROL_REG.
     */
    .u32_I_TX_A_106_01_ANA_TX_CLK_CONTROL_REG = 0x783,
    /**
     * Value for Register CLIF_TX_UNDERSHOOT_CONFIG_REG.
     */
    .u32_I_TX_A_106_02_TX_UNDERSHOOT_CONFIG_REG = 0x17,
    /**
     * Value for Register CLIF_TX_OVERSHOOT_CONFIG_REG.
     */
    .u32_I_TX_A_106_03_TX_OVERSHOOT_CONFIG_REG = 0x0,
    /**
     * Value for Register CLIF_ANA_TX_SHAPE_CONTROL_REG.
     */
    .u32_I_TX_A_106_04_ANA_TX_SHAPE_CONTROL_REG = 0x1b000f43,
    /**
     * Value for Register CLIF_TX_DATA_MOD_REG.
     */
    .u32_I_TX_A_106_05_TX_DATA_MOD_REG = 0x230104,
    /**
     * Value for Register CLIF_TX_SYMBOL23_MOD_REG.
     */
    .u32_I_TX_A_106_06_TX_SYMBOL23_MOD_REG = 0x230104,
    /**
     * Value for Register CLIF_TX_SYMBOL_CONFIG_REG.
     */
    .u32_I_TX_A_106_07_TX_SYMBOL_CONFIG_REG = 0x0,
    /**
     * Value for Register CLIF_TX_SYMBOL01_MOD_REG.
     */
    .u32_I_TX_A_106_08_TX_SYMBOL01_MOD_REG = 0x230104,
    /**
     * Value for Register CLIF_ANA_TX_AMPLITUDE_REG.
     *
     * Note: Configuration: I_TX_A_212 starts from here.
     */
    .u32_I_TX_A_212_00_ANA_TX_AMPLITUDE_REG = 0xffff50f4,
    /**
     * Value for Register CLIF_ANA_TX_CLK_CONTROL_REG.
     */
    .u32_I_TX_A_212_01_ANA_TX_CLK_CONTROL_REG = 0x83,
    /**
     * Value for Register CLIF_TX_UNDERSHOOT_CONFIG_REG.
     */
    .u32_I_TX_A_212_02_TX_UNDERSHOOT_CONFIG_REG = 0x5,
    /**
     * Value for Register CLIF_TX_OVERSHOOT_CONFIG_REG.
     */
    .u32_I_TX_A_212_03_TX_OVERSHOOT_CONFIG_REG = 0x0,
    /**
     * Value for Register CLIF_ANA_TX_SHAPE_CONTROL_REG.
     */
    .u32_I_TX_A_212_04_ANA_TX_SHAPE_CONTROL_REG = 0x1b000f43,
    /**
     * Value for Register CLIF_TX_DATA_MOD_REG.
     */
    .u32_I_TX_A_212_05_TX_DATA_MOD_REG = 0xf0105,
    /**
     * Value for Register CLIF_TX_SYMBOL23_MOD_REG.
     */
    .u32_I_TX_A_212_06_TX_SYMBOL23_MOD_REG = 0xf0105,
    /**
     * Value for Register CLIF_TX_SYMBOL_CONFIG_REG.
     */
    .u32_I_TX_A_212_07_TX_SYMBOL_CONFIG_REG = 0x0,
    /**
     * Value for Register CLIF_ANA_TX_AMPLITUDE_REG.
     *
     * Note: Configuration: I_TX_A_424 starts from here.
     */
    .u32_I_TX_A_424_00_ANA_TX_AMPLITUDE_REG = 0xffff50f4,
    /**
     * Value for Register CLIF_ANA_TX_CLK_CONTROL_REG.
     */
    .u32_I_TX_A_424_01_ANA_TX_CLK_CONTROL_REG = 0x83,
    /**
     * Value for Register CLIF_TX_UNDERSHOOT_CONFIG_REG.
     */
    .u32_I_TX_A_424_02_TX_UNDERSHOOT_CONFIG_REG = 0x5,
    /**
     * Value for Register CLIF_TX_OVERSHOOT_CONFIG_REG.
     */
    .u32_I_TX_A_424_03_TX_OVERSHOOT_CONFIG_REG = 0x0,
    /**
     * Value for Register CLIF_ANA_TX_SHAPE_CONTROL_REG.
     */
    .u32_I_TX_A_424_04_ANA_TX_SHAPE_CONTROL_REG = 0x1b000f43,
    /**
     * Value for Register CLIF_TX_DATA_MOD_REG.
     */
    .u32_I_TX_A_424_05_TX_DATA_MOD_REG = 0x60106,
    /**
     * Value for Register CLIF_TX_SYMBOL23_MOD_REG.
     */
    .u32_I_TX_A_424_06_TX_SYMBOL23_MOD_REG = 0x60106,
    /**
     * Value for Register CLIF_TX_SYMBOL_CONFIG_REG.
     */
    .u32_I_TX_A_424_07_TX_SYMBOL_CONFIG_REG = 0x0,
    /**
     * Value for Register CLIF_ANA_TX_AMPLITUDE_REG.
     *
     * Note: Configuration: I_TX_A_848 starts from here.
     */
    .u32_I_TX_A_848_00_ANA_TX_AMPLITUDE_REG = 0xffff507c,
    /**
     * Value for Register CLIF_ANA_TX_CLK_CONTROL_REG.
     */
    .u32_I_TX_A_848_01_ANA_TX_CLK_CONTROL_REG = 0x83,
    /**
     * Value for Register CLIF_TX_UNDERSHOOT_CONFIG_REG.
     */
    .u32_I_TX_A_848_02_TX_UNDERSHOOT_CONFIG_REG = 0x1,
    /**
     * Value for Register CLIF_TX_OVERSHOOT_CONFIG_REG.
     */
    .u32_I_TX_A_848_03_TX_OVERSHOOT_CONFIG_REG = 0x0,
    /**
     * Value for Register CLIF_ANA_TX_SHAPE_CONTROL_REG.
     */
    .u32_I_TX_A_848_04_ANA_TX_SHAPE_CONTROL_REG = 0x1f000f45,
    /**
     * Value for Register CLIF_TX_DATA_MOD_REG.
     */
    .u32_I_TX_A_848_05_TX_DATA_MOD_REG = 0x10107,
    /**
     * Value for Register CLIF_TX_SYMBOL23_MOD_REG.
     */
    .u32_I_TX_A_848_06_TX_SYMBOL23_MOD_REG = 0x20107,
    /**
     * Value for Register CLIF_TX_SYMBOL_CONFIG_REG.
     */
    .u32_I_TX_A_848_07_TX_SYMBOL_CONFIG_REG = 0x0,
    /**
     * Value for Register CLIF_ANA_TX_AMPLITUDE_REG.
     *
     * Note: Configuration: I_TX_B_106 starts from here.
     */
    .u32_I_TX_B_106_00_ANA_TX_AMPLITUDE_REG = 0xffff5094,
    /**
     * Value for Register CLIF_ANA_TX_CLK_CONTROL_REG.
     */
    .u32_I_TX_B_106_01_ANA_TX_CLK_CONTROL_REG = 0x8f,
    /**
     * Value for Register CLIF_TX_UNDERSHOOT_CONFIG_REG.
     */
    .u32_I_TX_B_106_02_TX_UNDERSHOOT_CONFIG_REG = 0x0,
    /**
     * Value for Register CLIF_TX_OVERSHOOT_CONFIG_REG.
     */
    .u32_I_TX_B_106_03_TX_OVERSHOOT_CONFIG_REG = 0x0,
    /**
     * Value for Register CLIF_ANA_TX_SHAPE_CONTROL_REG.
     */
    .u32_I_TX_B_106_04_ANA_TX_SHAPE_CONTROL_REG = 0x7000756,
    /**
     * Value for Register CLIF_TX_SYMBOL_CONFIG_REG.
     */
    .u32_I_TX_B_106_05_TX_SYMBOL_CONFIG_REG = 0x402b9,
    /**
     * Value for Register CLIF_TX_SYMBOL01_MOD_REG.
     */
    .u32_I_TX_B_106_06_TX_SYMBOL01_MOD_REG = 0x85,
    /**
     * Value for Register CLIF_TX_SYMBOL0_DEF_REG.
     */
    .u32_I_TX_B_106_07_TX_SYMBOL0_DEF_REG = 0x1f,
    /**
     * Value for Register CLIF_ANA_TX_AMPLITUDE_REG.
     *
     * Note: Configuration: I_TX_B_212 starts from here.
     */
    .u32_I_TX_B_212_00_ANA_TX_AMPLITUDE_REG = 0xffff5074,
    /**
     * Value for Register CLIF_ANA_TX_CLK_CONTROL_REG.
     */
    .u32_I_TX_B_212_01_ANA_TX_CLK_CONTROL_REG = 0x8f,
    /**
     * Value for Register CLIF_TX_UNDERSHOOT_CONFIG_REG.
     */
    .u32_I_TX_B_212_02_TX_UNDERSHOOT_CONFIG_REG = 0x0,
    /**
     * Value for Register CLIF_TX_OVERSHOOT_CONFIG_REG.
     */
    .u32_I_TX_B_212_03_TX_OVERSHOOT_CONFIG_REG = 0x0,
    /**
     * Value for Register CLIF_ANA_TX_SHAPE_CONTROL_REG.
     */
    .u32_I_TX_B_212_04_ANA_TX_SHAPE_CONTROL_REG = 0x7000746,
    /**
     * Value for Register CLIF_TX_SYMBOL_CONFIG_REG.
     */
    .u32_I_TX_B_212_05_TX_SYMBOL_CONFIG_REG = 0x4014c,
    /**
     * Value for Register CLIF_TX_SYMBOL01_MOD_REG.
     */
    .u32_I_TX_B_212_06_TX_SYMBOL01_MOD_REG = 0x85,
    /**
     * Value for Register CLIF_TX_SYMBOL0_DEF_REG.
     */
    .u32_I_TX_B_212_07_TX_SYMBOL0_DEF_REG = 0x3,
    /**
     * Value for Register CLIF_ANA_TX_AMPLITUDE_REG.
     *
     * Note: Configuration: I_TX_B_424 starts from here.
     */
    .u32_I_TX_B_424_00_ANA_TX_AMPLITUDE_REG = 0xffff5074,
    /**
     * Value for Register CLIF_ANA_TX_CLK_CONTROL_REG.
     */
    .u32_I_TX_B_424_01_ANA_TX_CLK_CONTROL_REG = 0x78f,
    /**
     * Value for Register CLIF_TX_UNDERSHOOT_CONFIG_REG.
     */
    .u32_I_TX_B_424_02_TX_UNDERSHOOT_CONFIG_REG = 0x0,
    /**
     * Value for Register CLIF_TX_OVERSHOOT_CONFIG_REG.
     */
    .u32_I_TX_B_424_03_TX_OVERSHOOT_CONFIG_REG = 0x1fe0013,
    /**
     * Value for Register CLIF_ANA_TX_SHAPE_CONTROL_REG.
     */
    .u32_I_TX_B_424_04_ANA_TX_SHAPE_CONTROL_REG = 0xe000f54,
    /**
     * Value for Register CLIF_TX_SYMBOL_CONFIG_REG.
     */
    .u32_I_TX_B_424_05_TX_SYMBOL_CONFIG_REG = 0x4014c,
    /**
     * Value for Register CLIF_TX_SYMBOL01_MOD_REG.
     */
    .u32_I_TX_B_424_06_TX_SYMBOL01_MOD_REG = 0x86,
    /**
     * Value for Register CLIF_TX_SYMBOL0_DEF_REG.
     */
    .u32_I_TX_B_424_07_TX_SYMBOL0_DEF_REG = 0x3,
    /**
     * Value for Register CLIF_ANA_TX_AMPLITUDE_REG.
     *
     * Note: Configuration: I_TX_B_848 starts from here.
     */
    .u32_I_TX_B_848_00_ANA_TX_AMPLITUDE_REG = 0xffff506c,
    /**
     * Value for Register CLIF_ANA_TX_CLK_CONTROL_REG.
     */
    .u32_I_TX_B_848_01_ANA_TX_CLK_CONTROL_REG = 0x78f,
    /**
     * Value for Register CLIF_TX_UNDERSHOOT_CONFIG_REG.
     */
    .u32_I_TX_B_848_02_TX_UNDERSHOOT_CONFIG_REG = 0x0,
    /**
     * Value for Register CLIF_TX_OVERSHOOT_CONFIG_REG.
     */
    .u32_I_TX_B_848_03_TX_OVERSHOOT_CONFIG_REG = 0x7e000d,
    /**
     * Value for Register CLIF_ANA_TX_SHAPE_CONTROL_REG.
     */
    .u32_I_TX_B_848_04_ANA_TX_SHAPE_CONTROL_REG = 0xd000f32,
    /**
     * Value for Register CLIF_TX_SYMBOL_CONFIG_REG.
     */
    .u32_I_TX_B_848_05_TX_SYMBOL_CONFIG_REG = 0x4014c,
    /**
     * Value for Register CLIF_TX_SYMBOL01_MOD_REG.
     */
    .u32_I_TX_B_848_06_TX_SYMBOL01_MOD_REG = 0x87,
    /**
     * Value for Register CLIF_TX_SYMBOL0_DEF_REG.
     */
    .u32_I_TX_B_848_07_TX_SYMBOL0_DEF_REG = 0x3,
    /**
     * Value for Register CLIF_ANA_TX_CLK_CONTROL_REG.
     *
     * Note: Configuration: I_TX_F starts from here.
     */
    .u32_I_TX_F_00_ANA_TX_CLK_CONTROL_REG = 0x8f,
    /**
     * Value for Register CLIF_ANA_TX_AMPLITUDE_REG.
     *
     * Note: Configuration: I_TX_F_212 starts from here.
     */
    .u32_I_TX_F_212_00_ANA_TX_AMPLITUDE_REG = 0xffff507c,
    /**
     * Value for Register CLIF_TX_UNDERSHOOT_CONFIG_REG.
     */
    .u32_I_TX_F_212_01_TX_UNDERSHOOT_CONFIG_REG = 0x0,
    /**
     * Value for Register CLIF_TX_OVERSHOOT_CONFIG_REG.
     */
    .u32_I_TX_F_212_02_TX_OVERSHOOT_CONFIG_REG = 0x0,
    /**
     * Value for Register CLIF_ANA_TX_SHAPE_CONTROL_REG.
     */
    .u32_I_TX_F_212_03_ANA_TX_SHAPE_CONTROL_REG = 0x7010744,
    /**
     * Value for Register CLIF_ANA_TX_AMPLITUDE_REG.
     *
     * Note: Configuration: I_TX_F_424 starts from here.
     */
    .u32_I_TX_F_424_00_ANA_TX_AMPLITUDE_REG = 0xffff507c,
    /**
     * Value for Register CLIF_TX_UNDERSHOOT_CONFIG_REG.
     */
    .u32_I_TX_F_424_01_TX_UNDERSHOOT_CONFIG_REG = 0x0,
    /**
     * Value for Register CLIF_TX_OVERSHOOT_CONFIG_REG.
     */
    .u32_I_TX_F_424_02_TX_OVERSHOOT_CONFIG_REG = 0x0,
    /**
     * Value for Register CLIF_ANA_TX_SHAPE_CONTROL_REG.
     */
    .u32_I_TX_F_424_03_ANA_TX_SHAPE_CONTROL_REG = 0x7010f33,
    /**
     * Value for Register CLIF_ANA_TX_AMPLITUDE_REG.
     *
     * Note: Configuration: I_TX_15693_100 starts from here.
     */
    .u32_I_TX_15693_100_00_ANA_TX_AMPLITUDE_REG = 0xffff50f4,
    /**
     * Value for Register CLIF_ANA_TX_CLK_CONTROL_REG.
     */
    .u32_I_TX_15693_100_01_ANA_TX_CLK_CONTROL_REG = 0x783,
    /**
     * Value for Register CLIF_TX_UNDERSHOOT_CONFIG_REG.
     */
    .u32_I_TX_15693_100_02_TX_UNDERSHOOT_CONFIG_REG = 0xf000001f,
    /**
     * Value for Register CLIF_TX_OVERSHOOT_CONFIG_REG.
     */
    .u32_I_TX_15693_100_03_TX_OVERSHOOT_CONFIG_REG = 0x0,
    /**
     * Value for Register CLIF_ANA_TX_SHAPE_CONTROL_REG.
     */
    .u32_I_TX_15693_100_04_ANA_TX_SHAPE_CONTROL_REG = 0x1b000745,
    /**
     * Value for Register CLIF_TX_DATA_MOD_REG.
     */
    .u32_I_TX_15693_100_05_TX_DATA_MOD_REG = 0x43,
    /**
     * Value for Register CLIF_TX_SYMBOL23_MOD_REG.
     */
    .u32_I_TX_15693_100_06_TX_SYMBOL23_MOD_REG = 0x4,
    /**
     * Value for Register CLIF_TX_SYMBOL_CONFIG_REG.
     */
    .u32_I_TX_15693_100_07_TX_SYMBOL_CONFIG_REG = 0x7c00,
    /**
     * Value for Register CLIF_ANA_TX_AMPLITUDE_REG.
     *
     * Note: Configuration: I_TX_15693_10 starts from here.
     */
    .u32_I_TX_15693_10_00_ANA_TX_AMPLITUDE_REG = 0xffff5090,
    /**
     * Value for Register CLIF_ANA_TX_CLK_CONTROL_REG.
     */
    .u32_I_TX_15693_10_01_ANA_TX_CLK_CONTROL_REG = 0x8f,
    /**
     * Value for Register CLIF_TX_UNDERSHOOT_CONFIG_REG.
     */
    .u32_I_TX_15693_10_02_TX_UNDERSHOOT_CONFIG_REG = 0xff000f,
    /**
     * Value for Register CLIF_TX_OVERSHOOT_CONFIG_REG.
     */
    .u32_I_TX_15693_10_03_TX_OVERSHOOT_CONFIG_REG = 0x0,
    /**
     * Value for Register CLIF_ANA_TX_SHAPE_CONTROL_REG.
     */
    .u32_I_TX_15693_10_04_ANA_TX_SHAPE_CONTROL_REG = 0x7010f44,
    /**
     * Value for Register CLIF_TX_DATA_MOD_REG.
     */
    .u32_I_TX_15693_10_05_TX_DATA_MOD_REG = 0x43,
    /**
     * Value for Register CLIF_TX_SYMBOL23_MOD_REG.
     */
    .u32_I_TX_15693_10_06_TX_SYMBOL23_MOD_REG = 0x4,
    /**
     * Value for Register CLIF_TX_SYMBOL_CONFIG_REG.
     */
    .u32_I_TX_15693_10_07_TX_SYMBOL_CONFIG_REG = 0x7c00,
    /**
     * Value for Register CLIF_ANA_TX_AMPLITUDE_REG.
     *
     * Note: Configuration: I_TX_EPCV2_TARI_9_44 starts from here.
     */
    .u32_I_TX_EPCV2_TARI_9_44_00_ANA_TX_AMPLITUDE_REG = 0xfffff094,
    /**
     * Value for Register CLIF_ANA_TX_CLK_CONTROL_REG.
     */
    .u32_I_TX_EPCV2_TARI_9_44_01_ANA_TX_CLK_CONTROL_REG = 0x8f,
    /**
     * Value for Register CLIF_TX_UNDERSHOOT_CONFIG_REG.
     */
    .u32_I_TX_EPCV2_TARI_9_44_02_TX_UNDERSHOOT_CONFIG_REG = 0xff000f,
    /**
     * Value for Register CLIF_TX_OVERSHOOT_CONFIG_REG.
     */
    .u32_I_TX_EPCV2_TARI_9_44_03_TX_OVERSHOOT_CONFIG_REG = 0x0,
    /**
     * Value for Register CLIF_ANA_TX_SHAPE_CONTROL_REG.
     */
    .u32_I_TX_EPCV2_TARI_9_44_04_ANA_TX_SHAPE_CONTROL_REG = 0x7000734,
    /**
     * Value for Register CLIF_TX_SYMBOL_CONFIG_REG.
     */
    .u32_I_TX_EPCV2_TARI_9_44_05_TX_SYMBOL_CONFIG_REG = 0xed,
    /**
     * Value for Register CLIF_TX_SYMBOL0_DEF_REG.
     */
    .u32_I_TX_EPCV2_TARI_9_44_06_TX_SYMBOL0_DEF_REG = 0x2841,
    /**
     * Value for Register CLIF_TX_SYMBOL1_DEF_REG.
     */
    .u32_I_TX_EPCV2_TARI_9_44_07_TX_SYMBOL1_DEF_REG = 0xa1,
    /**
     * Value for Register CLIF_ANA_TX_AMPLITUDE_REG.
     *
     * Note: Configuration: I_TX_EPCV2_TARI_18_88 starts from here.
     */
    .u32_I_TX_EPCV2_TARI_18_88_00_ANA_TX_AMPLITUDE_REG = 0xfffff08c,
    /**
     * Value for Register CLIF_ANA_TX_CLK_CONTROL_REG.
     */
    .u32_I_TX_EPCV2_TARI_18_88_01_ANA_TX_CLK_CONTROL_REG = 0x8f,
    /**
     * Value for Register CLIF_TX_UNDERSHOOT_CONFIG_REG.
     */
    .u32_I_TX_EPCV2_TARI_18_88_02_TX_UNDERSHOOT_CONFIG_REG = 0xff000f,
    /**
     * Value for Register CLIF_TX_OVERSHOOT_CONFIG_REG.
     */
    .u32_I_TX_EPCV2_TARI_18_88_03_TX_OVERSHOOT_CONFIG_REG = 0x0,
    /**
     * Value for Register CLIF_ANA_TX_SHAPE_CONTROL_REG.
     */
    .u32_I_TX_EPCV2_TARI_18_88_04_ANA_TX_SHAPE_CONTROL_REG = 0x7000734,
    /**
     * Value for Register CLIF_TX_SYMBOL_CONFIG_REG.
     */
    .u32_I_TX_EPCV2_TARI_18_88_05_TX_SYMBOL_CONFIG_REG = 0xed,
    /**
     * Value for Register CLIF_TX_SYMBOL0_DEF_REG.
     */
    .u32_I_TX_EPCV2_TARI_18_88_06_TX_SYMBOL0_DEF_REG = 0x2841,
    /**
     * Value for Register CLIF_TX_SYMBOL1_DEF_REG.
     */
    .u32_I_TX_EPCV2_TARI_18_88_07_TX_SYMBOL1_DEF_REG = 0xa1,
    /**
     * Value for Register CLIF_ANA_PBF_CONTROL_REG.
     *
     * Note: Configuration: I_TX_ACT starts from here.
     */
    .u32_I_TX_ACT_00_ANA_PBF_CONTROL_REG = 0xa0,
    /**
     * Value for Register CLIF_TRANSCEIVE_CONTROL_REG.
     *
     * Note: Configuration: I_TX_ACT_106 starts from here.
     */
    .u32_I_TX_ACT_106_00_TRANSCEIVE_CONTROL_REG = 0x35003,
    /**
     * Value for Register CLIF_ANA_TX_AMPLITUDE_REG.
     */
    .u32_I_TX_ACT_106_01_ANA_TX_AMPLITUDE_REG = 0xffff50f4,
    /**
     * Value for Register CLIF_ANA_TX_CLK_CONTROL_REG.
     */
    .u32_I_TX_ACT_106_02_ANA_TX_CLK_CONTROL_REG = 0x783,
    /**
     * Value for Register CLIF_TX_UNDERSHOOT_CONFIG_REG.
     */
    .u32_I_TX_ACT_106_03_TX_UNDERSHOOT_CONFIG_REG = 0x17,
    /**
     * Value for Register CLIF_TX_OVERSHOOT_CONFIG_REG.
     */
    .u32_I_TX_ACT_106_04_TX_OVERSHOOT_CONFIG_REG = 0x0,
    /**
     * Value for Register CLIF_ANA_TX_SHAPE_CONTROL_REG.
     */
    .u32_I_TX_ACT_106_05_ANA_TX_SHAPE_CONTROL_REG = 0x1b000f43,
    /**
     * Value for Register CLIF_TX_DATA_MOD_REG.
     */
    .u32_I_TX_ACT_106_06_TX_DATA_MOD_REG = 0x230104,
    /**
     * Value for Register CLIF_TX_SYMBOL23_MOD_REG.
     */
    .u32_I_TX_ACT_106_07_TX_SYMBOL23_MOD_REG = 0x260104,
    /**
     * Value for Register CLIF_TX_SYMBOL_CONFIG_REG.
     */
    .u32_I_TX_ACT_106_08_TX_SYMBOL_CONFIG_REG = 0x9,
    /**
     * Value for Register CLIF_TX_SYMBOL01_MOD_REG.
     */
    .u32_I_TX_ACT_106_09_TX_SYMBOL01_MOD_REG = 0x230104,
    /**
     * Value for Register CLIF_TRANSCEIVE_CONTROL_REG.
     *
     * Note: Configuration: I_TX_ACT_212 starts from here.
     */
    .u32_I_TX_ACT_212_00_TRANSCEIVE_CONTROL_REG = 0x30001,
    /**
     * Value for Register CLIF_ANA_TX_AMPLITUDE_REG.
     */
    .u32_I_TX_ACT_212_01_ANA_TX_AMPLITUDE_REG = 0xffff507c,
    /**
     * Value for Register CLIF_ANA_TX_CLK_CONTROL_REG.
     */
    .u32_I_TX_ACT_212_02_ANA_TX_CLK_CONTROL_REG = 0x8f,
    /**
     * Value for Register CLIF_TX_UNDERSHOOT_CONFIG_REG.
     */
    .u32_I_TX_ACT_212_03_TX_UNDERSHOOT_CONFIG_REG = 0x0,
    /**
     * Value for Register CLIF_TX_OVERSHOOT_CONFIG_REG.
     */
    .u32_I_TX_ACT_212_04_TX_OVERSHOOT_CONFIG_REG = 0x0,
    /**
     * Value for Register CLIF_ANA_TX_SHAPE_CONTROL_REG.
     */
    .u32_I_TX_ACT_212_05_ANA_TX_SHAPE_CONTROL_REG = 0x7010f44,
    /**
     * Value for Register CLIF_TX_DATA_MOD_REG.
     */
    .u32_I_TX_ACT_212_06_TX_DATA_MOD_REG = 0x15,
    /**
     * Value for Register CLIF_TX_SYMBOL_CONFIG_REG.
     */
    .u32_I_TX_ACT_212_07_TX_SYMBOL_CONFIG_REG = 0x31000f,
    /**
     * Value for Register CLIF_TX_SYMBOL01_MOD_REG.
     */
    .u32_I_TX_ACT_212_08_TX_SYMBOL01_MOD_REG = 0x15,
    /**
     * Value for Register CLIF_TRANSCEIVE_CONTROL_REG.
     *
     * Note: Configuration: I_TX_ACT_424 starts from here.
     */
    .u32_I_TX_ACT_424_00_TRANSCEIVE_CONTROL_REG = 0x30001,
    /**
     * Value for Register CLIF_ANA_TX_AMPLITUDE_REG.
     */
    .u32_I_TX_ACT_424_01_ANA_TX_AMPLITUDE_REG = 0xffff507c,
    /**
     * Value for Register CLIF_ANA_TX_CLK_CONTROL_REG.
     */
    .u32_I_TX_ACT_424_02_ANA_TX_CLK_CONTROL_REG = 0x8f,
    /**
     * Value for Register CLIF_TX_UNDERSHOOT_CONFIG_REG.
     */
    .u32_I_TX_ACT_424_03_TX_UNDERSHOOT_CONFIG_REG = 0x0,
    /**
     * Value for Register CLIF_TX_OVERSHOOT_CONFIG_REG.
     */
    .u32_I_TX_ACT_424_04_TX_OVERSHOOT_CONFIG_REG = 0x0,
    /**
     * Value for Register CLIF_ANA_TX_SHAPE_CONTROL_REG.
     */
    .u32_I_TX_ACT_424_05_ANA_TX_SHAPE_CONTROL_REG = 0x7010f33,
    /**
     * Value for Register CLIF_TX_DATA_MOD_REG.
     */
    .u32_I_TX_ACT_424_06_TX_DATA_MOD_REG = 0x16,
    /**
     * Value for Register CLIF_TX_SYMBOL_CONFIG_REG.
     */
    .u32_I_TX_ACT_424_07_TX_SYMBOL_CONFIG_REG = 0x31000f,
    /**
     * Value for Register CLIF_TX_SYMBOL01_MOD_REG.
     */
    .u32_I_TX_ACT_424_08_TX_SYMBOL01_MOD_REG = 0x16,
    /**
     * Value for Register CLIF_TRANSCEIVE_CONTROL_REG.
     *
     * Note: Configuration: I_TX_BOOT starts from here.
     */
    .u32_I_TX_BOOT_00_TRANSCEIVE_CONTROL_REG = 0x0,
    /**
     * Value for Register CLIF_ANA_PBF_CONTROL_REG.
     */
    .u32_I_TX_BOOT_01_ANA_PBF_CONTROL_REG = 0xa0,
    /**
     * Value for Register CLIF_ANA_TX_AMPLITUDE_REG.
     */
    .u32_I_TX_BOOT_02_ANA_TX_AMPLITUDE_REG = 0xffff0003,
    /**
     * Value for Register CLIF_ANA_TX_CLK_CONTROL_REG.
     */
    .u32_I_TX_BOOT_03_ANA_TX_CLK_CONTROL_REG = 0x83,
    /**
     * Value for Register CLIF_TX_UNDERSHOOT_CONFIG_REG.
     */
    .u32_I_TX_BOOT_04_TX_UNDERSHOOT_CONFIG_REG = 0x0,
    /**
     * Value for Register CLIF_TX_OVERSHOOT_CONFIG_REG.
     */
    .u32_I_TX_BOOT_05_TX_OVERSHOOT_CONFIG_REG = 0x0,
    /**
     * Value for Register CLIF_ANA_TX_SHAPE_CONTROL_REG.
     */
    .u32_I_TX_BOOT_06_ANA_TX_SHAPE_CONTROL_REG = 0x0,
    /**
     * Value for Register CLIF_TX_DATA_MOD_REG.
     */
    .u32_I_TX_BOOT_07_TX_DATA_MOD_REG = 0x0,
    /**
     * Value for Register CLIF_TX_SYMBOL23_MOD_REG.
     */
    .u32_I_TX_BOOT_08_TX_SYMBOL23_MOD_REG = 0x0,
    /**
     * Value for Register CLIF_TX_SYMBOL_CONFIG_REG.
     */
    .u32_I_TX_BOOT_09_TX_SYMBOL_CONFIG_REG = 0x0,
    /**
     * Value for Register CLIF_ANA_CLK_MAN_REG.
     */
    .u32_I_TX_BOOT_10_ANA_CLK_MAN_REG = 0x0,
    /**
     * Value for Register CLIF_TX_SYMBOL01_MOD_REG.
     */
    .u32_I_TX_BOOT_11_TX_SYMBOL01_MOD_REG = 0x0,
    /**
     * Value for Register CLIF_TX_SYMBOL0_DEF_REG.
     */
    .u32_I_TX_BOOT_12_TX_SYMBOL0_DEF_REG = 0x0,
    /**
     * Value for Register CLIF_TX_SYMBOL1_DEF_REG.
     */
    .u32_I_TX_BOOT_13_TX_SYMBOL1_DEF_REG = 0x0,
    /**
     * Value for Register CLIF_TEST_CONTROL_REG.
     */
    .u32_I_TX_BOOT_14_TEST_CONTROL_REG = 0x280000,

};
const phCfg_EE_phRFLP_I_Tx_val_t * const gpkphCfg_EE_phRFLP_I_Tx_val = &gkphCfg_EE_phRFLP_I_Tx_val_PF;

/** Structure: I_Rx_val
 *
 *             Value to be applied to the corresponding CLIF register for CLIF Initiator Mode - Receive.
 *
 */
static const phCfg_EE_phRFLP_I_Rx_val_t gkphCfg_EE_phRFLP_I_Rx_val_PF = {
    /**
     * Value for Register CLIF_ANA_AGC_REG.
     *
     * Note: Configuration: I_RX_PASS starts from here.
     */
    .u32_I_RX_PASS_00_ANA_AGC_REG = 0x2,
    /**
     * Value for Register CLIF_AGC_INPUT_REG.
     */
    .u32_I_RX_PASS_01_AGC_INPUT_REG = 0x20001f0,
    /**
     * Value for Register CLIF_ANA_RX_REG.
     *
     * Note: Configuration: I_RX_A_106_P starts from here.
     */
    .u32_I_RX_A_106_P_00_ANA_RX_REG = 0x2002f,
    /**
     * Value for Register CLIF_SIGPRO_RM_CONFIG1_REG.
     */
    .u32_I_RX_A_106_P_01_SIGPRO_RM_CONFIG1_REG = 0x440dc,
    /**
     * Value for Register CLIF_AGC_CONFIG1_REG.
     */
    .u32_I_RX_A_106_P_02_AGC_CONFIG1_REG = 0x3e40104,
    /**
     * Value for Register CLIF_AGC_CONFIG0_REG.
     */
    .u32_I_RX_A_106_P_03_AGC_CONFIG0_REG = 0x7001008b,
    /**
     * Value for Register CLIF_RX_CONFIG_REG.
     */
    .u32_I_RX_A_106_P_04_RX_CONFIG_REG = 0x3,
    /**
     * Value for Register CLIF_ANA_RX_REG.
     *
     * Note: Configuration: I_RX_A_212 starts from here.
     */
    .u32_I_RX_A_212_00_ANA_RX_REG = 0x20026,
    /**
     * Value for Register CLIF_SIGPRO_RM_CONFIG1_REG.
     */
    .u32_I_RX_A_212_01_SIGPRO_RM_CONFIG1_REG = 0x1192605,
    /**
     * Value for Register CLIF_AGC_CONFIG1_REG.
     */
    .u32_I_RX_A_212_02_AGC_CONFIG1_REG = 0x3e10a04,
    /**
     * Value for Register CLIF_AGC_CONFIG0_REG.
     */
    .u32_I_RX_A_212_03_AGC_CONFIG0_REG = 0x40c0b,
    /**
     * Value for Register CLIF_RX_CONFIG_REG.
     */
    .u32_I_RX_A_212_04_RX_CONFIG_REG = 0x23,
    /**
     * Value for Register CLIF_ANA_RX_REG.
     *
     * Note: Configuration: I_RX_A_424 starts from here.
     */
    .u32_I_RX_A_424_00_ANA_RX_REG = 0x20026,
    /**
     * Value for Register CLIF_SIGPRO_RM_CONFIG1_REG.
     */
    .u32_I_RX_A_424_01_SIGPRO_RM_CONFIG1_REG = 0x1192905,
    /**
     * Value for Register CLIF_AGC_CONFIG1_REG.
     */
    .u32_I_RX_A_424_02_AGC_CONFIG1_REG = 0x3e10a04,
    /**
     * Value for Register CLIF_AGC_CONFIG0_REG.
     */
    .u32_I_RX_A_424_03_AGC_CONFIG0_REG = 0x40c0b,
    /**
     * Value for Register CLIF_RX_CONFIG_REG.
     */
    .u32_I_RX_A_424_04_RX_CONFIG_REG = 0x23,
    /**
     * Value for Register CLIF_ANA_RX_REG.
     *
     * Note: Configuration: I_RX_A_848 starts from here.
     */
    .u32_I_RX_A_848_00_ANA_RX_REG = 0x20021,
    /**
     * Value for Register CLIF_SIGPRO_RM_CONFIG1_REG.
     */
    .u32_I_RX_A_848_01_SIGPRO_RM_CONFIG1_REG = 0x10f2505,
    /**
     * Value for Register CLIF_AGC_CONFIG1_REG.
     */
    .u32_I_RX_A_848_02_AGC_CONFIG1_REG = 0x3e10a04,
    /**
     * Value for Register CLIF_AGC_CONFIG0_REG.
     */
    .u32_I_RX_A_848_03_AGC_CONFIG0_REG = 0x40c0b,
    /**
     * Value for Register CLIF_RX_CONFIG_REG.
     */
    .u32_I_RX_A_848_04_RX_CONFIG_REG = 0x23,
    /**
     * Value for Register CLIF_AGC_CONFIG1_REG.
     *
     * Note: Configuration: I_RX_B starts from here.
     */
    .u32_I_RX_B_00_AGC_CONFIG1_REG = 0x3e10a04,
    /**
     * Value for Register CLIF_AGC_CONFIG0_REG.
     */
    .u32_I_RX_B_01_AGC_CONFIG0_REG = 0x40c0b,
    /**
     * Value for Register CLIF_RX_CONFIG_REG.
     */
    .u32_I_RX_B_02_RX_CONFIG_REG = 0x54,
    /**
     * Value for Register CLIF_ANA_RX_REG.
     *
     * Note: Configuration: I_RX_B_106 starts from here.
     */
    .u32_I_RX_B_106_00_ANA_RX_REG = 0x2002b,
    /**
     * Value for Register CLIF_SIGPRO_RM_CONFIG1_REG.
     */
    .u32_I_RX_B_106_01_SIGPRO_RM_CONFIG1_REG = 0x11f4615,
    /**
     * Value for Register CLIF_ANA_RX_REG.
     *
     * Note: Configuration: I_RX_B_212 starts from here.
     */
    .u32_I_RX_B_212_00_ANA_RX_REG = 0x20026,
    /**
     * Value for Register CLIF_SIGPRO_RM_CONFIG1_REG.
     */
    .u32_I_RX_B_212_01_SIGPRO_RM_CONFIG1_REG = 0x1192805,
    /**
     * Value for Register CLIF_ANA_RX_REG.
     *
     * Note: Configuration: I_RX_B_424 starts from here.
     */
    .u32_I_RX_B_424_00_ANA_RX_REG = 0x20026,
    /**
     * Value for Register CLIF_SIGPRO_RM_CONFIG1_REG.
     */
    .u32_I_RX_B_424_01_SIGPRO_RM_CONFIG1_REG = 0x1192a05,
    /**
     * Value for Register CLIF_ANA_RX_REG.
     *
     * Note: Configuration: I_RX_B_848 starts from here.
     */
    .u32_I_RX_B_848_00_ANA_RX_REG = 0x2002a,
    /**
     * Value for Register CLIF_SIGPRO_RM_CONFIG1_REG.
     */
    .u32_I_RX_B_848_01_SIGPRO_RM_CONFIG1_REG = 0x10f2505,
    /**
     * Value for Register CLIF_AGC_CONFIG1_REG.
     *
     * Note: Configuration: I_RX_F_P starts from here.
     */
    .u32_I_RX_F_P_00_AGC_CONFIG1_REG = 0x3e10a04,
    /**
     * Value for Register CLIF_AGC_CONFIG0_REG.
     */
    .u32_I_RX_F_P_01_AGC_CONFIG0_REG = 0x40c0b,
    /**
     * Value for Register CLIF_RX_CONFIG_REG.
     */
    .u32_I_RX_F_P_02_RX_CONFIG_REG = 0x38,
    /**
     * Value for Register CLIF_ANA_RX_REG.
     *
     * Note: Configuration: I_RX_F_212_P starts from here.
     */
    .u32_I_RX_F_212_P_00_ANA_RX_REG = 0x20021,
    /**
     * Value for Register CLIF_SIGPRO_RM_CONFIG1_REG.
     */
    .u32_I_RX_F_212_P_01_SIGPRO_RM_CONFIG1_REG = 0x10f2605,
    /**
     * Value for Register CLIF_ANA_RX_REG.
     *
     * Note: Configuration: I_RX_F_424_P starts from here.
     */
    .u32_I_RX_F_424_P_00_ANA_RX_REG = 0x20025,
    /**
     * Value for Register CLIF_SIGPRO_RM_CONFIG1_REG.
     */
    .u32_I_RX_F_424_P_01_SIGPRO_RM_CONFIG1_REG = 0x10f2605,
    /**
     * Value for Register CLIF_AGC_CONFIG1_REG.
     *
     * Note: Configuration: I_RX_15693 starts from here.
     */
    .u32_I_RX_15693_00_AGC_CONFIG1_REG = 0x3e40104,
    /**
     * Value for Register CLIF_AGC_CONFIG0_REG.
     */
    .u32_I_RX_15693_01_AGC_CONFIG0_REG = 0x7000008b,
    /**
     * Value for Register CLIF_RX_CONFIG_REG.
     */
    .u32_I_RX_15693_02_RX_CONFIG_REG = 0x1d10,
    /**
     * Value for Register CLIF_ANA_RX_REG.
     *
     * Note: Configuration: I_RX_15693_26 starts from here.
     */
    .u32_I_RX_15693_26_00_ANA_RX_REG = 0x2002a,
    /**
     * Value for Register CLIF_SIGPRO_RM_CONFIG1_REG.
     */
    .u32_I_RX_15693_26_01_SIGPRO_RM_CONFIG1_REG = 0xc4010,
    /**
     * Value for Register CLIF_ANA_RX_REG.
     *
     * Note: Configuration: I_RX_15693_53 starts from here.
     */
    .u32_I_RX_15693_53_00_ANA_RX_REG = 0x2002a,
    /**
     * Value for Register CLIF_SIGPRO_RM_CONFIG1_REG.
     */
    .u32_I_RX_15693_53_01_SIGPRO_RM_CONFIG1_REG = 0xc4010,
    /**
     * Value for Register CLIF_AGC_CONFIG1_REG.
     *
     * Note: Configuration: I_RX_EPCV2 starts from here.
     */
    .u32_I_RX_EPCV2_00_AGC_CONFIG1_REG = 0x3e40a04,
    /**
     * Value for Register CLIF_AGC_CONFIG0_REG.
     */
    .u32_I_RX_EPCV2_01_AGC_CONFIG0_REG = 0xc0b,
    /**
     * Value for Register CLIF_ANA_RX_REG.
     *
     * Note: Configuration: I_RX_EPCV2_SC424_2MP starts from here.
     */
    .u32_I_RX_EPCV2_SC424_2MP_00_ANA_RX_REG = 0x2002e,
    /**
     * Value for Register CLIF_SIGPRO_RM_CONFIG1_REG.
     */
    .u32_I_RX_EPCV2_SC424_2MP_01_SIGPRO_RM_CONFIG1_REG = 0xc6014,
    /**
     * Value for Register CLIF_ANA_RX_REG.
     *
     * Note: Configuration: I_RX_EPCV2_SC424_4MP starts from here.
     */
    .u32_I_RX_EPCV2_SC424_4MP_00_ANA_RX_REG = 0x2002a,
    /**
     * Value for Register CLIF_SIGPRO_RM_CONFIG1_REG.
     */
    .u32_I_RX_EPCV2_SC424_4MP_01_SIGPRO_RM_CONFIG1_REG = 0xc8014,
    /**
     * Value for Register CLIF_ANA_RX_REG.
     *
     * Note: Configuration: I_RX_EPCV2_SC848_2MP starts from here.
     */
    .u32_I_RX_EPCV2_SC848_2MP_00_ANA_RX_REG = 0x2002f,
    /**
     * Value for Register CLIF_SIGPRO_RM_CONFIG1_REG.
     */
    .u32_I_RX_EPCV2_SC848_2MP_01_SIGPRO_RM_CONFIG1_REG = 0xc8094,
    /**
     * Value for Register CLIF_ANA_RX_REG.
     *
     * Note: Configuration: I_RX_EPCV2_SC848_4MP starts from here.
     */
    .u32_I_RX_EPCV2_SC848_4MP_00_ANA_RX_REG = 0x20022,
    /**
     * Value for Register CLIF_SIGPRO_RM_CONFIG1_REG.
     */
    .u32_I_RX_EPCV2_SC848_4MP_01_SIGPRO_RM_CONFIG1_REG = 0xc7094,
    /**
     * Value for Register CLIF_ANA_AGC_REG.
     *
     * Note: Configuration: I_RX_ACT starts from here.
     */
    .u32_I_RX_ACT_00_ANA_AGC_REG = 0x2,
    /**
     * Value for Register CLIF_SIGPRO_RM_CONFIG1_REG.
     */
    .u32_I_RX_ACT_01_SIGPRO_RM_CONFIG1_REG = 0x10ccc05,
    /**
     * Value for Register CLIF_AGC_INPUT_REG.
     */
    .u32_I_RX_ACT_02_AGC_INPUT_REG = 0x3000150,
    /**
     * Value for Register CLIF_ANA_CM_CONFIG_REG.
     */
    .u32_I_RX_ACT_03_ANA_CM_CONFIG_REG = 0x14080,
    /**
     * Value for Register CLIF_BBA_CONTROL_REG.
     */
    .u32_I_RX_ACT_04_BBA_CONTROL_REG = 0x0,
    /**
     * Value for Register CLIF_ANA_CLK_MAN_REG.
     */
    .u32_I_RX_ACT_05_ANA_CLK_MAN_REG = 0x10,
    /**
     * Value for Register CLIF_ANA_RX_REG.
     *
     * Note: Configuration: I_RX_ACT_106 starts from here.
     */
    .u32_I_RX_ACT_106_00_ANA_RX_REG = 0x390a3,
    /**
     * Value for Register CLIF_AGC_CONFIG1_REG.
     */
    .u32_I_RX_ACT_106_01_AGC_CONFIG1_REG = 0x207ff6,
    /**
     * Value for Register CLIF_AGC_CONFIG0_REG.
     */
    .u32_I_RX_ACT_106_02_AGC_CONFIG0_REG = 0x4400b,
    /**
     * Value for Register CLIF_SIGPRO_CM_CONFIG_REG.
     */
    .u32_I_RX_ACT_106_03_SIGPRO_CM_CONFIG_REG = 0x104,
    /**
     * Value for Register CLIF_RX_CONFIG_REG.
     */
    .u32_I_RX_ACT_106_04_RX_CONFIG_REG = 0x113,
    /**
     * Value for Register CLIF_ANA_RX_REG.
     *
     * Note: Configuration: I_RX_ACT_212 starts from here.
     */
    .u32_I_RX_ACT_212_00_ANA_RX_REG = 0x390a3,
    /**
     * Value for Register CLIF_AGC_CONFIG1_REG.
     */
    .u32_I_RX_ACT_212_01_AGC_CONFIG1_REG = 0x207ff6,
    /**
     * Value for Register CLIF_AGC_CONFIG0_REG.
     */
    .u32_I_RX_ACT_212_02_AGC_CONFIG0_REG = 0x4400b,
    /**
     * Value for Register CLIF_SIGPRO_CM_CONFIG_REG.
     */
    .u32_I_RX_ACT_212_03_SIGPRO_CM_CONFIG_REG = 0x6206,
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_THRESHOLD_REG.
     */
    .u32_I_RX_ACT_212_04_SIGPRO_ADCBCM_THRESHOLD_REG = 0x80060,
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_CONFIG_REG.
     */
    .u32_I_RX_ACT_212_05_SIGPRO_ADCBCM_CONFIG_REG = 0xf805d05,
    /**
     * Value for Register CLIF_RX_CONFIG_REG.
     */
    .u32_I_RX_ACT_212_06_RX_CONFIG_REG = 0x38,
    /**
     * Value for Register CLIF_ANA_RX_REG.
     *
     * Note: Configuration: I_RX_ACT_424 starts from here.
     */
    .u32_I_RX_ACT_424_00_ANA_RX_REG = 0x390a3,
    /**
     * Value for Register CLIF_AGC_CONFIG1_REG.
     */
    .u32_I_RX_ACT_424_01_AGC_CONFIG1_REG = 0x207ff6,
    /**
     * Value for Register CLIF_AGC_CONFIG0_REG.
     */
    .u32_I_RX_ACT_424_02_AGC_CONFIG0_REG = 0x4400b,
    /**
     * Value for Register CLIF_SIGPRO_CM_CONFIG_REG.
     */
    .u32_I_RX_ACT_424_03_SIGPRO_CM_CONFIG_REG = 0x6206,
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_THRESHOLD_REG.
     */
    .u32_I_RX_ACT_424_04_SIGPRO_ADCBCM_THRESHOLD_REG = 0x80060,
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_CONFIG_REG.
     */
    .u32_I_RX_ACT_424_05_SIGPRO_ADCBCM_CONFIG_REG = 0xf805d09,
    /**
     * Value for Register CLIF_RX_CONFIG_REG.
     */
    .u32_I_RX_ACT_424_06_RX_CONFIG_REG = 0x38,
    /**
     * Value for Register CLIF_ANA_RX_REG.
     *
     * Note: Configuration: I_RX_BOOT starts from here.
     */
    .u32_I_RX_BOOT_00_ANA_RX_REG = 0x3db20,
    /**
     * Value for Register CLIF_ANA_AGC_REG.
     */
    .u32_I_RX_BOOT_01_ANA_AGC_REG = 0x2,
    /**
     * Value for Register CLIF_SIGPRO_RM_CONFIG1_REG.
     */
    .u32_I_RX_BOOT_02_SIGPRO_RM_CONFIG1_REG = 0xc0000,
    /**
     * Value for Register CLIF_AGC_CONFIG1_REG.
     */
    .u32_I_RX_BOOT_03_AGC_CONFIG1_REG = 0x10107ff7,
    /**
     * Value for Register CLIF_AGC_CONFIG0_REG.
     */
    .u32_I_RX_BOOT_04_AGC_CONFIG0_REG = 0x4007,
    /**
     * Value for Register CLIF_AGC_INPUT_REG.
     */
    .u32_I_RX_BOOT_05_AGC_INPUT_REG = 0x3000150,
    /**
     * Value for Register CLIF_ANA_CM_CONFIG_REG.
     */
    .u32_I_RX_BOOT_06_ANA_CM_CONFIG_REG = 0xc080,
    /**
     * Value for Register CLIF_ANA_TEST_REG.
     */
    .u32_I_RX_BOOT_07_ANA_TEST_REG = 0x50004a,
    /**
     * Value for Register CLIF_ANA_NFCLD_REG.
     */
    .u32_I_RX_BOOT_08_ANA_NFCLD_REG = 0x1c,
    /**
     * Value for Register CLIF_SIGPRO_CM_CONFIG_REG.
     */
    .u32_I_RX_BOOT_09_SIGPRO_CM_CONFIG_REG = 0x4,
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_THRESHOLD_REG.
     */
    .u32_I_RX_BOOT_10_SIGPRO_ADCBCM_THRESHOLD_REG = 0x0,
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_CONFIG_REG.
     */
    .u32_I_RX_BOOT_11_SIGPRO_ADCBCM_CONFIG_REG = 0x1000000,
    /**
     * Value for Register CLIF_RX_CONFIG_REG.
     */
    .u32_I_RX_BOOT_12_RX_CONFIG_REG = 0x2,
    /**
     * Value for Register CLIF_BBA_CONTROL_REG.
     */
    .u32_I_RX_BOOT_13_BBA_CONTROL_REG = 0x0,

};
const phCfg_EE_phRFLP_I_Rx_val_t * const gpkphCfg_EE_phRFLP_I_Rx_val = &gkphCfg_EE_phRFLP_I_Rx_val_PF;

/* ****************************************************************************************************************** */
/** \name Page: Trailer
 *
                Trailer region of the EEPROM.  This region does not contain any function data/values.
                Test cases can write scratch data beyond this region.
 */

/** Structure: Last
 *
 *                     Last structure on EEPROM. Starting from this address/region,
 *                     there is nothing relevent for the example/reference implementation.
 *
 */
static const phCfg_EE_Trailer_Last_t gkphCfg_EE_Trailer_Last_PF = {
    /**
     * Dummy Byte for the Structure
     */
    .dummyByte = 0x32363437,

};
const phCfg_EE_Trailer_Last_t * const gpkphCfg_EE_Trailer_Last = &gkphCfg_EE_Trailer_Last_PF;

#endif /* NXPBUILD__CFG_FROM_PF */
