/*
 * Copyright (c) 2008-2016, RF-Embedded GmbH
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice,
 *     this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright notice,
 *     this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
 * SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef CPPRFEMESSAGEQUEUE_H
#define CPPRFEMESSAGEQUEUE_H

#include "../types.h"
#include "../helper/Mutex.h"
#include "../helper/Sleeper.h"

#include <map>
#include <list>
#include <vector>

namespace CPPrfeReaderInterface
{

    /// <summary>
    /// Class to store recieved messages.
    /// </summary>
    class CPPrfeMessageQueue
    {
    public:
        /// <summary>
        /// Constructs a new message queue
        /// </summary>
        CPPrfeMessageQueue();

        /// <summary>
        /// Enqueues the given message with the given id. If a message with this id is already present, it is replaced.
        /// </summary>
        /// <param name="id">Message id</param>
        /// <param name="message">Message</param>
        void enqueueMessage(ushort id, std::vector<byte> message);

        /// <summary>
        /// Waits for a message with the given message id for the given time.
        /// </summary>
        /// <param name="id">Message id to wait for</param>
        /// <param name="msecs">Maximum time to wait for the message</param>
        /// <param name="ok">Result of the waiting</param>
        /// <returns>The message, if the operation did not succeeed, null is returned.</returns>
        std::vector<byte> waitForMessage(ushort id, int msecs, bool& ok);

        void clearMessage(ushort id);

    private:
        /// <summary>
        /// The stored messages
        /// </summary>
        std::map<ushort, std::list<std::vector<byte> > >     m_messageQueue;

        /// <summary>
        /// Mutex to secure the access
        /// </summary>
        Mutex                                               m_mutex;
    };

};

#endif // CPPRFEMESSAGEQUEUE_H
