/*
 * Copyright (c) 2008-2016, RF-Embedded GmbH
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice,
 *     this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright notice,
 *     this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
 * SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef CPPRFEPURPROTOCOLHANDLER_H
#define CPPRFEPURPROTOCOLHANDLER_H

#include "CPPrfeProtocolHandler.h"

namespace CPPrfeReaderInterface
{

    class CPPrfePURprotocolHandler : public CPPrfeProtocolHandler
    {
    public:
        CPPrfePURprotocolHandler(IProtocolDeviceInterface* device);

        bool getPostDetectReadParams(bool& on, byte& memBank, ushort& address, byte& size, std::vector<byte>& password);
        bool setPostDetectReadParams(bool on, byte memBank, ushort address, byte size, std::vector<byte> password);

        bool getReadBlockSize(byte& wordCount);
        bool setReadBlockSize(byte wordCount);

        bool blockWriteToTag(std::vector<byte> epc, byte mem_bank, ushort address, std::vector<byte> passwd, byte blockSize, std::vector<byte> data);

        bool getTagHandle(std::vector<byte> epc, std::vector<byte>& handle);
        bool readFromHandle(std::vector<byte> handle, byte mem_bank, ushort address, std::vector<byte> passwd, byte count, std::vector<byte>& data);
        bool writeToHandle(std::vector<byte> handle, byte mem_bank, ushort address, std::vector<byte> passwd, std::vector<byte> data);
        bool blockWriteToHandle(std::vector<byte> handle, byte mem_bank, ushort address, std::vector<byte> passwd, byte blockSize, std::vector<byte> data);
        bool customGen2Command(std::vector<byte> handle, std::vector<byte> command, std::vector<byte> passwd, byte txBitCount, std::vector<byte> txBits, bool& headerBit, std::vector<byte>& rxBytes);
        bool customGen2Command(std::vector<byte> handle, std::vector<byte> command, std::vector<byte> passwd, byte txBitCount, std::vector<byte> txBits, byte estimatedRxCount, bool& headerBit, std::vector<byte>& rxBytes);
        bool customGen2Command(std::vector<byte> handle, std::vector<byte> command, std::vector<byte> passwd, byte txBitCount, std::vector<byte> txBits, byte estimatedRxCount, byte estimatedTagProcessingTime, bool& headerBit, std::vector<byte>& rxBytes);
        bool customGen2Command(std::vector<byte> handle, std::vector<byte> command, std::vector<byte> passwd, byte txBitCount, std::vector<byte> txBits, std::vector<byte> additionalInfo, bool& headerBit, std::vector<byte>& rxBytes);


    //*********************************************************************** Input
    protected:
        virtual void notificationISR(const std::vector<byte>& payload);

    public:
        class EventListener
        {
        public:
            /// <summary>
            /// Delegate is called everytime an inventory round ended.
            /// </summary>
            virtual void InventoryRoundEndedHandler() = 0;
        };

        void setEventListener(CPPrfePURprotocolHandler::EventListener* listener);
    private:
        CPPrfePURprotocolHandler::EventListener*      m_purEventListener;
    };

};
#endif // CPPRFEPURPROTOCOLHANDLER_H
