/*
 * Copyright (c) 2008-2016, RF-Embedded GmbH
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice,
 *     this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright notice,
 *     this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
 * SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef TESTPROGRAM_H
#define TESTPROGRAM_H

#include <CPPrfeReaderInterface.h>
#include <protocol/CPPrfeProtocolHandler.h>
#include <protocol/CPPrfePURprotocolHandler.h>


using namespace CPPrfeReaderInterface;

class TestProgram : public CPPrfeProtocolHandler::EventListener
{
public:
    TestProgram();
    ~TestProgram();

    bool init();

    void print(const char* str);
    void print(const std::string& str);

    void test_Inventory();

private:
    CPPrfeReaderInterface::CPPrfeProtocolHandler*  m_ph;

    // EventListener interface
public:
    void HeartBeatHandler(const std::vector<byte> &data);
    void CyclicInventoryHandler(const CPPrfeTagEvent &tagEvent);
    void StateChangedHandler(eRFE_CURRENT_READER_STATE newState);
    void StatusRegisterChangedHandler(ulonglong statusRegister);
    void GpioValuesChangedHandler(ulong gpioValues);
    void NotificationHandler(const std::vector<byte> &payload);
    void ApplicationEventHandler(const std::vector<byte> &payload);

private:
    ulong       m_cyclicInvCount;

    bool                                     m_lastTagEventValid;
    CPPrfeReaderInterface::CPPrfeTagEvent    m_lastTagEvent;
};

#endif // TESTPROGRAM_H
