﻿/*
 * Copyright (c) 2008-2014, RF-Embedded GmbH
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 * 
 *  1. Redistributions of source code must retain the above copyright notice, 
 *     this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright notice, 
 *     this list of conditions and the following disclaimer in the 
 *     documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
 * SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT 
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR 
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;

namespace Implementation
{
    /// <summary>
    /// Implementation of a trace interface to a file
    /// </summary>
    internal class FileTrace : CSrfeReaderInterface.trace.ITraceInterface
    {
        private static System.IO.StreamWriter supportWriter; 

        /// <summary>
        /// Creates a new object of the file tracer
        /// </summary>
        public FileTrace()
        {
            string support_filePath = System.IO.Directory.GetCurrentDirectory() + "\\" + DateTime.Now.ToString("yyyyMMdd_HHmmss") + "_trcFile.txt";
            supportWriter = new System.IO.StreamWriter(support_filePath);
        }

        /// <summary>
        /// Writes a message to the file
        /// </summary>
        /// <param name="text">The trace message to write</param>
        public override void write(string text)
        {
            string msg = "[" + DateTime.Now.ToString("HH:mm:ss.ffff") + "] - " + text;
            supportWriter.WriteLine(msg);
        }
    }
}
