﻿/*
 * Copyright (c) 2008-2018, RF-Embedded GmbH
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 * 
 *  1. Redistributions of source code must retain the above copyright notice, 
 *     this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright notice, 
 *     this list of conditions and the following disclaimer in the 
 *     documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
 * SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT 
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR 
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

 using CSrfeReaderInterface.device;
using CSrfeReaderInterface.impl.device;
using CSrfeReaderInterface.protocol;
using System;


namespace CSrfeTest_SimpleReadTest
{
    class CSrfeTest_SimpleReadTest
    {
        /**************************************************************************/
        // TODO: Change this for your device:
        private string SerialPort = "COM7";
        /**************************************************************************/

        protected CSrfeProtocolHandler _ph = null;
        protected ulong _tagReadCount = 0;

        /// <summary>
        /// Empty constructor
        /// </summary>
        public CSrfeTest_SimpleReadTest()
        {
        }

        /// <summary>
        /// Test routine
        /// </summary>
        public void execute()
        {
            bool ok = false;

            // Create communication device
            IProtocolDeviceInterface device = new SerialDevice(SerialPort);
            if (!device.Open())
            {
                Console.WriteLine("ERROR: Could not open device at " + SerialPort + " - Please change the com port in the code:");
                Console.WriteLine("  private string SerialPort = \"COMXX\";");

                // wait for <enter>
                Console.ReadLine();
                return;
            }

            // Create Protocol handler
            _ph = new CSrfePURprotocolHandler(device);
            _ph.CyclicInventory += new CSrfeProtocolHandler.CyclicInventoryHandler(onCyclicInventory);


            //***********************************************************************
            // Test communication by reading the reader id
            Console.WriteLine("\t -> 1, Read ReaderID");
            
            // get reader id
            uint readerId = 0;
            ok = _ph.getReaderID(out readerId);
            if (!ok)
            {
                Console.WriteLine("ERROR: Could not get ReaderID");
                return;
            }

            //***********************************************************************
            // Test the scan
            Console.WriteLine("Testing Cyclic Inventory:");

            // turn on cyclic inventory
            Console.WriteLine("\t -> 2, Starting Cyclic Inventory (Press Enter to Stop)");
            _tagReadCount = 0;
            DateTime startTime = DateTime.Now;
            _ph.setCyclicInventory(true);

            // wait for <enter>
            Console.ReadLine();

            // turn off cyclic inventory and calculate read rate
            _ph.setCyclicInventory(false);
            double secs = DateTime.Now.Subtract(startTime).TotalSeconds;
            Console.WriteLine("\t -> 3, Stopped Cyclic Inventry with a ReadRate of {0} reads/sec", _tagReadCount / secs);

            // wait for <enter>
            Console.ReadLine();
        }

        /// <summary>
        /// Event handler for cyclic inventory event
        /// </summary>
        /// <param name="tagEvent">The tag event detected and sent by the reader</param>
        public void onCyclicInventory(CSrfeProtocolHandler.TagEvent tagEvent)
        {
            Console.Write("\t\t{0:D8}  {1} \n", ++_tagReadCount, BitConverter.ToString(tagEvent.tagId));
        }


        /// <summary>
        /// Main routine
        /// </summary>
        /// <param name="args">arguments</param>
        static void Main(string[] args)
        {
            CSrfeTest_SimpleReadTest p = new CSrfeTest_SimpleReadTest();
            p.execute();
        }
    }
}
