/*
 * Copyright (c) 2008-2014, RF-Embedded GmbH
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 * 
 *  1. Redistributions of source code must retain the above copyright notice, 
 *     this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright notice, 
 *     this list of conditions and the following disclaimer in the 
 *     documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
 * SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT 
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR 
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.rfe.device;

/**
 * Interface which is used by the protocol handler to communicate with the reader.
 */
public abstract class IProtocolDeviceInterface {

    /**
     * Opens the device
     * @returns 		true if opening was successful, otherwise false
     */
    public abstract boolean open();

    /**
     * Closes the device
     * @returns			true if closing was successful, otherwise false
     */
    public abstract boolean close();

    /**
     * Sends the given bytes to the device
     * @param data		Data to be sent
 	 * @returns			true if sending was successful, otherwise false
 	 */
    public abstract boolean send(byte[] data);
    
    /**
     * The stored listener
     */
    private Listener m_listener = null;
    
	public interface Listener {
        /**
         * Called when connection was closed.
         */
        public void onConnectionOpened(boolean success);
        
		/**
		 * Called when connection was closed.
		 */
		public void onConnectionClosed();

		/**
		 * Called when new incoming data is available.
		 */
		public void onNewData(byte[] data);

		/**
		 * Called when device aborts due to an
		 * error.
		 */
		public void onRunError(Exception e);
	}
	
	/**
	 * Sets the given listener
	 * @param listener	The desired listener
	 */
    public synchronized void setListener(Listener listener) {
    	m_listener = listener;
    }

    /**
     * Returns the listener
     * @return		The current set listener
     */
    public synchronized Listener getListener() {
        return m_listener;
    }

}
