/*
 * Copyright (c) 2008-2018, RF-Embedded GmbH
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice,
 *     this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright notice,
 *     this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
 * SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef QRFEPURPROTOCOLHANDLER_H
#define QRFEPURPROTOCOLHANDLER_H

#include "QrfeProtocolHandler.h"

namespace QrfeReaderInterface
{
    /**
     * @brief The QrfePURprotocolHandler class is an implementation of the RF-Embedded Reader-Host-Protocol with PUR specific functions.
     */
    class QrfePURprotocolHandler : public QrfeProtocolHandler
    {
    public:
        QrfePURprotocolHandler(QIODevice *device, QObject* parent = 0);

        bool postDetectReadParams ( bool &on, uchar &memBank, ushort &address, uchar &size, QByteArray& password );
        bool setPostDetectReadParams ( bool on, uchar memBank, ushort address, uchar size, QByteArray password );

        bool blockWriteToTag ( QByteArray tagId, uchar mem_bank, ushort address, QByteArray passwd, uchar blockSize, QByteArray data );

        bool getTagHandle ( QByteArray tagId, QByteArray& handle );
        bool readFromHandle ( QByteArray handle, uchar mem_bank, ushort address, QByteArray passwd, uchar count, QByteArray& data );
        bool writeToHandle ( QByteArray handle, uchar mem_bank, ushort address, QByteArray passwd, QByteArray data );
        bool blockWriteToHandle ( QByteArray handle, uchar mem_bank, ushort address, QByteArray passwd, uchar blockSize, QByteArray data );
        bool customGen2Command ( QByteArray handle, QByteArray command, QByteArray passwd, uchar txBitCount, QByteArray txBits, bool& headerBit, QByteArray& rxBytes );
    };

}

#endif // QRFEPURPROTOCOLHANDLER_H
