/*
 * Copyright (c) 2008-2018, RF-Embedded GmbH
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice,
 *     this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright notice,
 *     this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
 * SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef QRFETAGEVENT_H
#define QRFETAGEVENT_H

#include <QByteArray>

namespace QrfeReaderInterface
{
    /**
     * @brief The QrfeTagEvent class stores a tag event and all of its data.
     */
    class QrfeTagEvent
    {
    public:
        QrfeTagEvent();
        QrfeTagEvent(const QrfeTagEvent& other);

    public:
        QByteArray tagId;

        bool hasAntenna;
        uchar antennaId;

        bool hasRSSI;
        QByteArray rssi;

        bool hasReadFrequency;
        ulong readFrequency;

        bool hasMemory;
        uchar memBank;
        ushort memAddr;
        QByteArray memData;

        bool hasTrigger;
        uchar trigger;

        bool hasHandle;
        QByteArray handle;

        bool hasState;
        ushort state;

        bool hasBattery;
        uchar battery;

        bool hasPC;
        QByteArray pc;

        bool hasMessageID;
        uchar messageID;

        bool hasApplicationInfo;
        QByteArray applicationInfo;

    public:
        QString toString() const;
    };
}

#endif // QRFETAGEVENT_H
